/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.test;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class BaseReplicationTestCase {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.ext.BaseReplicationTestCase");
    protected static final int BUFFER_SIZE = 1024;
    public static final int DIVIDER = 255;
    public static final double ONE_SECONDS = 1000.0;
    protected Session session;
    protected Node rootNode;
    private Credentials credentials;
    protected Repository repository;

    public BaseReplicationTestCase(RepositoryService repositoryService, String reposytoryName, String workspaceName, String userName, String password) {
        try {
            this.credentials = new CredentialsImpl(userName, password.toCharArray());
            this.repository = repositoryService.getRepository(reposytoryName);
            this.session = this.repository.login(this.credentials, workspaceName);
            this.rootNode = this.session.getRootNode();
        }
        catch (RepositoryException e) {
            log.error((Object)"Can't start BaseReplicationTestCase", (Throwable)e);
        }
        catch (RepositoryConfigurationException e) {
            log.error((Object)"Can't start BaseReplicationTestCase", (Throwable)e);
        }
    }

    protected Node addNodePath(String repoPath) throws RepositoryException {
        String[] sArray;
        Node resultNode = this.rootNode;
        for (String nodeName : sArray = repoPath.split("[::]")) {
            if (nodeName.equals("")) continue;
            resultNode = resultNode.hasNode(nodeName) ? resultNode.getNode(nodeName) : resultNode.addNode(nodeName, "nt:unstructured");
        }
        return resultNode;
    }

    protected String getNormalizePath(String repoPath) {
        return repoPath.replaceAll("[:][:]", "/");
    }

    protected void compareStream(InputStream etalon, InputStream data) throws Exception {
        this.compareStream(etalon, data, 0L, 0L, -1L);
    }

    protected void compareStream(InputStream etalon, InputStream data, long etalonPos, long dataPos, long length) throws Exception {
        int dindex = 0;
        byte[] ebuff = new byte[1024];
        int eread = 0;
        while ((eread = etalon.read(ebuff)) > 0) {
            byte[] dbuff = new byte[eread];
            int erindex = 0;
            while (erindex < eread) {
                int dread = -1;
                try {
                    dread = data.read(dbuff);
                }
                catch (IOException e) {
                    throw new Exception("Streams is not equals by length or data stream is unreadable. Cause: " + e.getMessage());
                }
                if (dread == -1) {
                    throw new Exception("Streams is not equals by length. Data end-of-stream reached at position " + dindex);
                }
                for (int i = 0; i < dread; ++i) {
                    byte eb = ebuff[i];
                    byte db = dbuff[i];
                    if (eb != db) {
                        throw new Exception("Streams is not equals. Wrong byte stored at position " + dindex + " of data stream. Expected 0x" + Integer.toHexString(eb) + " '" + new String(new byte[]{eb}) + "' but found 0x" + Integer.toHexString(db) + " '" + new String(new byte[]{db}) + "'");
                    }
                    ++erindex;
                    if (length <= 0L || (long)(++dindex) < length) continue;
                    return;
                }
                if (dread >= eread) continue;
                dbuff = new byte[eread - dread];
            }
        }
        if (data.available() > 0) {
            throw new Exception("Streams is not equals by length. Data stream contains more data. Were read " + dindex);
        }
    }
}

