/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.xerces.impl.dv.xs.EqualityHelper;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSElementDeclHelper;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSOpenContentDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.XS11AllCM;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.models.XSDFACM;
import org.apache.xerces.impl.xs.models.XSEmptyCM;
import org.apache.xerces.impl.xs.util.XS11TypeHelper;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.XSNamedMap;

public final class XS11CMRestriction
implements XSElementDeclHelper {
    private final SubstitutionGroupHandler sgh;
    private final XSGrammarBucket gb;
    private final CMBuilder cmb;
    private final XSConstraints xsc;
    private XS11CM base;
    private XS11CM derived;
    private XS11AllCM allb;
    private XS11AllCM alld;
    private XSDFACM dfab;
    private final QName qname = new QName();
    private final List states = new ArrayList();
    private StatePair pair = null;
    private short wType;
    private final List wNSList = new ArrayList();
    private final List wNSListTemp = new ArrayList();
    private final List wDNList = new ArrayList();
    private boolean wDD;
    private boolean wDS;
    private final List wANList = new ArrayList();
    private List globals;
    private List siblingsB;
    private List siblingsD;
    private XSElementDecl eb;
    private XSElementDecl ed;
    private XSWildcardDecl wb;
    private XSWildcardDecl wd;
    private int[] b;
    private int[] bn;
    private int[] d;
    private int[] dn;
    private final int[] indexb = new int[1];
    private final int[] indexd = new int[1];
    private boolean matchedHead;

    public XS11CMRestriction(XSCMValidator xSCMValidator, XSCMValidator xSCMValidator2, SubstitutionGroupHandler substitutionGroupHandler, XSGrammarBucket xSGrammarBucket, CMBuilder cMBuilder, XSConstraints xSConstraints) {
        this.base = (XS11CM)xSCMValidator;
        this.derived = (XS11CM)xSCMValidator2;
        this.sgh = substitutionGroupHandler;
        this.gb = xSGrammarBucket;
        this.cmb = cMBuilder;
        this.xsc = xSConstraints;
    }

    private void addState() {
        this.derived.optimizeStates(this.base, this.bn, this.dn, this.indexb[0]);
        if (this.pair == null) {
            this.pair = new StatePair(this.bn, this.dn);
        } else {
            this.pair.set(this.bn, this.dn);
        }
        if (!this.states.contains(this.pair)) {
            this.states.add(this.pair);
            this.pair = null;
        }
    }

    private void copyDerivedWildcard() {
        int n;
        int n2;
        this.wType = this.wd.fType;
        this.wDD = this.wd.fDisallowedDefined;
        this.wDS = this.wd.fDisallowedSibling;
        this.wNSList.clear();
        if (this.wType == 1) {
            this.wType = (short)2;
        } else {
            n2 = this.wd.fNamespaceList == null ? 0 : this.wd.fNamespaceList.length;
            for (n = 0; n < n2; ++n) {
                this.wNSList.add(this.wd.fNamespaceList[n]);
            }
        }
        n2 = this.wd.fDisallowedNamesList == null ? 0 : this.wd.fDisallowedNamesList.length;
        for (n = 0; n < n2; ++n) {
            this.wDNList.add(this.wd.fDisallowedNamesList[n].uri);
            this.wDNList.add(this.wd.fDisallowedNamesList[n].localpart);
        }
        this.wANList.clear();
    }

    private void addAN(String string, String string2) {
        if (!this.allowNS(string)) {
            return;
        }
        int n = 0;
        while (n < this.wDNList.size()) {
            if (this.wDNList.get(n++) != string || this.wDNList.get(n++) != string2) continue;
            return;
        }
        this.qname.uri = string;
        this.qname.localpart = string2;
        if (!this.derived.allowExpandedName(this.wd, this.qname, this.sgh, this)) {
            return;
        }
        this.wANList.add(string);
        this.wANList.add(string2);
    }

    private boolean allowNS(String string) {
        return this.wType == 1 || this.wType == 2 && !this.wNSList.contains(string) || this.wType == 3 && this.wNSList.contains(string);
    }

    private boolean allowName(String string, String string2) {
        int n;
        if (!this.allowNS(string)) {
            return false;
        }
        for (n = 0; n < this.wDNList.size(); n += 2) {
            if (string != this.wDNList.get(n) || string2 != this.wDNList.get(n + 1)) continue;
            return false;
        }
        for (n = 0; n < this.wANList.size(); n += 2) {
            if (string != this.wANList.get(n) || string2 != this.wANList.get(n + 1)) continue;
            return true;
        }
        this.qname.uri = string;
        this.qname.localpart = string2;
        return this.derived.allowExpandedName(this.wd, this.qname, this.sgh, this);
    }

    private boolean emptyWildcard() {
        return this.wType == 3 && this.wNSList.size() == 0 && this.wANList.size() == 0;
    }

    private void getGlobalElements() {
        this.globals = new ArrayList();
        SchemaGrammar[] schemaGrammarArray = this.gb.getGrammars();
        for (int i = 0; i < schemaGrammarArray.length; ++i) {
            this.addGlobals(schemaGrammarArray[i]);
        }
    }

    private void addGlobals(SchemaGrammar schemaGrammar) {
        XSNamedMap xSNamedMap = schemaGrammar.getComponents((short)2);
        for (int i = 0; i < xSNamedMap.getLength(); ++i) {
            XSElementDecl xSElementDecl = (XSElementDecl)xSNamedMap.item(i);
            this.globals.add(xSElementDecl.fTargetNamespace);
            this.globals.add(xSElementDecl.fName);
        }
    }

    private void getBaseSiblings() {
        this.siblingsB = this.base.getDefinedNames(this.sgh);
    }

    private void getDerivedSiblings() {
        this.siblingsD = this.derived.getDefinedNames(this.sgh);
    }

    public XSElementDecl getGlobalElementDecl(QName qName) {
        SchemaGrammar schemaGrammar = this.gb.getGrammar(qName.uri);
        return schemaGrammar != null ? schemaGrammar.getGlobalElementDecl(qName.localpart) : null;
    }

    public boolean check() {
        Serializable serializable;
        this.b = this.base.startContentModel();
        this.bn = this.base.startContentModel();
        this.d = this.derived.startContentModel();
        this.dn = this.derived.startContentModel();
        if (this.derived instanceof XS11AllCM) {
            this.alld = (XS11AllCM)this.derived;
            serializable = this.checkAllDerived();
            if (serializable != null) {
                return (Boolean)serializable;
            }
        }
        serializable = new ArrayList();
        int n = 0;
        StatePair statePair = new StatePair(this.b, this.d);
        this.states.add(statePair);
        while (n < this.states.size()) {
            StatePair statePair2 = (StatePair)this.states.get(n++);
            statePair2.getStates(this.b, this.d);
            serializable.clear();
            this.indexd[0] = -1;
            while ((this.ed = this.derived.nextElementTransition(this.d, this.dn, this.indexd)) != null) {
                serializable.add(this.ed.fTargetNamespace);
                serializable.add(this.ed.fName);
                if (this.ed.getScope() == 1) {
                    XSElementDecl[] xSElementDeclArray = this.sgh.getSubstitutionGroup(this.ed, (short)4);
                    for (int i = 0; i < xSElementDeclArray.length; ++i) {
                        serializable.add(xSElementDeclArray[i].fTargetNamespace);
                        serializable.add(xSElementDeclArray[i].fName);
                    }
                }
                if (this.matchElementInBase()) continue;
                return false;
            }
            this.indexd[0] = -1;
            while ((this.wd = this.derived.nextWildcardTransition(this.d, this.dn, this.indexd)) != null) {
                this.wDNList.clear();
                this.wDNList.addAll(serializable);
                if (this.matchWildcardInBase()) continue;
                return false;
            }
        }
        return this.checkFinalStates();
    }

    private boolean matchElementInBase() {
        this.matchedHead = false;
        if (!this.findElementInBase()) {
            return false;
        }
        this.addState();
        if (this.matchedHead) {
            return true;
        }
        XSElementDecl[] xSElementDeclArray = this.sgh.getSubstitutionGroup(this.ed, (short)4);
        for (int i = 0; i < xSElementDeclArray.length; ++i) {
            this.ed = xSElementDeclArray[i];
            if (!this.findElementInBase()) {
                return false;
            }
            this.addState();
        }
        return true;
    }

    private boolean findElementInBase() {
        this.indexb[0] = -1;
        while ((this.eb = this.base.nextElementTransition(this.b, this.bn, this.indexb)) != null) {
            if (!this.matchElementWithBaseElement()) continue;
            return this.checkEERestriction();
        }
        this.indexb[0] = -1;
        while ((this.wb = this.base.nextWildcardTransition(this.b, this.bn, this.indexb)) != null) {
            this.qname.uri = this.ed.fTargetNamespace;
            this.qname.localpart = this.ed.fName;
            if (!this.base.allowExpandedName(this.wb, this.qname, this.sgh, this)) continue;
            return this.checkEWRestriction();
        }
        return false;
    }

    private boolean matchElementWithBaseElement() {
        if (this.eb.getName() == this.ed.getName() && this.eb.getNamespace() == this.ed.getNamespace()) {
            this.matchedHead = this.eb == this.ed;
            return true;
        }
        XSElementDecl[] xSElementDeclArray = this.sgh.getSubstitutionGroup(this.eb, (short)4);
        for (int i = 0; i < xSElementDeclArray.length; ++i) {
            if (xSElementDeclArray[i].getName() != this.ed.getName() || xSElementDeclArray[i].getNamespace() != this.ed.getNamespace()) continue;
            this.eb = xSElementDeclArray[i];
            return true;
        }
        return false;
    }

    private boolean checkEERestriction() {
        if (this.eb == this.ed) {
            return true;
        }
        if (!this.eb.getNillable() && this.ed.getNillable()) {
            return false;
        }
        if (this.eb.getConstraintType() == 2) {
            if (this.ed.getConstraintType() != 2) {
                return false;
            }
            if (!EqualityHelper.isEqual(this.eb.fDefault, this.ed.fDefault, (short)4)) {
                return false;
            }
        }
        if (!this.checkIDConstraintRestriction(this.ed, this.eb)) {
            return false;
        }
        if ((this.ed.fBlock & this.eb.fBlock) != this.eb.fBlock) {
            return false;
        }
        if (!this.xsc.checkTypeDerivationOk(this.ed.fType, this.eb.fType, (short)25)) {
            return false;
        }
        return !XS11TypeHelper.isTypeTablesComparable(this.eb.getTypeAlternatives(), this.ed.getTypeAlternatives()) || this.xsc.isTypeTablesEquivalent(this.eb, this.ed);
    }

    private boolean checkIDConstraintRestriction(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2) {
        IdentityConstraint[] identityConstraintArray = xSElementDecl.getIDConstraints();
        IdentityConstraint[] identityConstraintArray2 = xSElementDecl2.getIDConstraints();
        int n = identityConstraintArray2 == null ? 0 : identityConstraintArray2.length;
        int n2 = identityConstraintArray == null ? 0 : identityConstraintArray.length;
        for (int i = 0; i < n; ++i) {
            int n3;
            for (n3 = 0; n3 < n2 && identityConstraintArray2[i] != identityConstraintArray[n3]; ++n3) {
            }
            if (n3 != identityConstraintArray.length) continue;
            return false;
        }
        return true;
    }

    private boolean checkEWRestriction() {
        if (this.wb.getProcessContents() == 2) {
            return true;
        }
        this.qname.uri = this.ed.fTargetNamespace;
        this.qname.localpart = this.ed.fName;
        this.eb = this.getGlobalElementDecl(this.qname);
        if (this.eb == null) {
            return this.wb.getProcessContents() == 3;
        }
        return this.checkEERestriction();
    }

    private boolean matchWildcardInBase() {
        XSElementDecl[] xSElementDeclArray;
        Object object;
        this.copyDerivedWildcard();
        if (this.derived.isOpenContent(this.wd)) {
            object = new int[]{-1};
            while (!this.emptyWildcard() && (xSElementDeclArray = this.derived.nextWildcardTransition(this.d, this.dn, (int[])object)) != null) {
                if (xSElementDeclArray == this.wd) continue;
                this.subtractWildcard((XSWildcardDecl)xSElementDeclArray, true);
            }
        }
        this.indexb[0] = -1;
        while ((this.eb = this.base.nextElementTransition(this.b, this.bn, this.indexb)) != null) {
            object = this.checkWERestriction();
            if (object != null) {
                if (!object.booleanValue()) {
                    return false;
                }
                this.addState();
            }
            if (this.eb.getScope() != 1) continue;
            xSElementDeclArray = this.sgh.getSubstitutionGroup(this.eb, (short)4);
            for (int i = 0; i < xSElementDeclArray.length; ++i) {
                this.eb = xSElementDeclArray[i];
                object = this.checkWERestriction();
                if (object == null) continue;
                if (!object.booleanValue()) {
                    return false;
                }
                this.addState();
            }
        }
        this.indexb[0] = -1;
        while (!this.emptyWildcard() && (this.wb = this.base.nextWildcardTransition(this.b, this.bn, this.indexb)) != null) {
            if (!this.subtractWildcard(this.wb, false)) continue;
            if (this.wd.weakerProcessContents(this.wb)) {
                return false;
            }
            this.addState();
        }
        return this.emptyWildcard();
    }

    private Boolean checkWERestriction() {
        if (!this.allowName(this.eb.fTargetNamespace, this.eb.fName)) {
            return null;
        }
        if (this.wd.fProcessContents == 2) {
            return Boolean.FALSE;
        }
        this.ed = this.getGlobalElementDecl(this.qname);
        if (this.ed == null) {
            return Boolean.FALSE;
        }
        if (this.ed != this.eb && !this.checkEERestriction()) {
            return Boolean.FALSE;
        }
        this.wDNList.add(this.eb.fTargetNamespace);
        this.wDNList.add(this.eb.fName);
        return Boolean.TRUE;
    }

    private boolean subtractWildcard(XSWildcardDecl xSWildcardDecl, boolean bl) {
        String string;
        String string2;
        int n;
        int n2;
        boolean bl2 = false;
        if (!bl && this.base.isOpenContent(xSWildcardDecl) && this.wANList.size() > 0) {
            n2 = 0;
            while (n2 < this.wANList.size()) {
                this.qname.uri = (String)this.wANList.get(n2++);
                this.qname.localpart = (String)this.wANList.get(n2++);
                if (this.base.allowExpandedName(xSWildcardDecl, this.qname, this.sgh, this)) continue;
                return false;
            }
            this.wANList.clear();
            bl2 = true;
        }
        n2 = xSWildcardDecl.fDisallowedNamesList == null ? 0 : xSWildcardDecl.fDisallowedNamesList.length;
        for (n = 0; n < n2; ++n) {
            this.addAN(xSWildcardDecl.fDisallowedNamesList[n].uri, xSWildcardDecl.fDisallowedNamesList[n].localpart);
        }
        if (xSWildcardDecl.fDisallowedDefined && !this.wDD) {
            if (this.globals == null) {
                this.getGlobalElements();
            }
            n = 0;
            while (n < this.globals.size()) {
                string2 = (String)this.globals.get(n++);
                string = (String)this.globals.get(n++);
                if (!xSWildcardDecl.allowNamespace(string2)) continue;
                this.addAN(string2, string);
            }
        }
        if (xSWildcardDecl.fDisallowedSibling) {
            if (!bl) {
                if (this.siblingsB == null) {
                    this.getBaseSiblings();
                }
                n = 0;
                while (n < this.siblingsB.size()) {
                    string2 = (String)this.siblingsB.get(n++);
                    string = (String)this.siblingsB.get(n++);
                    if (!xSWildcardDecl.allowNamespace(string2)) continue;
                    this.addAN(string2, string);
                }
            } else if (!this.wDS) {
                if (this.siblingsD == null) {
                    this.getDerivedSiblings();
                }
                n = 0;
                while (n < this.siblingsD.size()) {
                    string2 = (String)this.siblingsD.get(n++);
                    string = (String)this.siblingsD.get(n++);
                    if (!xSWildcardDecl.allowNamespace(string2)) continue;
                    this.addAN(string2, string);
                }
            }
        }
        if (xSWildcardDecl.getConstraintType() == 1) {
            this.wType = (short)3;
            this.wNSList.clear();
            return true;
        }
        if (xSWildcardDecl.getConstraintType() == 2) {
            if (this.wType == 2) {
                this.wType = (short)3;
                this.wNSListTemp.clear();
                for (n = 0; n < xSWildcardDecl.fNamespaceList.length; ++n) {
                    if (this.wNSList.contains(xSWildcardDecl.fNamespaceList[n])) continue;
                    this.wNSListTemp.add(xSWildcardDecl.fNamespaceList[n]);
                }
                this.wNSList.clear();
                this.wNSList.addAll(this.wNSListTemp);
                return true;
            }
            this.wNSListTemp.clear();
            for (n = 0; n < xSWildcardDecl.fNamespaceList.length; ++n) {
                if (!this.wNSList.contains(xSWildcardDecl.fNamespaceList[n])) continue;
                this.wNSListTemp.add(xSWildcardDecl.fNamespaceList[n]);
            }
            if (this.wNSList.size() == this.wNSListTemp.size()) {
                return bl2;
            }
            this.wNSList.clear();
            this.wNSList.addAll(this.wNSListTemp);
            return true;
        }
        if (this.wType == 2) {
            for (n = 0; n < xSWildcardDecl.fNamespaceList.length; ++n) {
                if (this.wNSList.contains(xSWildcardDecl.fNamespaceList[n])) continue;
                this.wNSList.add(xSWildcardDecl.fNamespaceList[n]);
                bl2 = true;
            }
        } else {
            for (n = 0; n < xSWildcardDecl.fNamespaceList.length; ++n) {
                if (!this.wNSList.remove(xSWildcardDecl.fNamespaceList[n])) continue;
                bl2 = true;
            }
        }
        return bl2;
    }

    private boolean checkFinalStates() {
        for (int i = 0; i < this.states.size(); ++i) {
            StatePair statePair = (StatePair)this.states.get(i);
            statePair.getStates(this.b, this.d);
            if (!this.derived.endContentModel(this.d) || this.base.endContentModel(this.b)) continue;
            return false;
        }
        return true;
    }

    private Boolean checkAllDerived() {
        Boolean bl;
        if (this.base instanceof XSEmptyCM && (bl = this.checkAllEmpty()) != null) {
            return bl;
        }
        if (this.base instanceof XS11AllCM) {
            this.allb = (XS11AllCM)this.base;
            bl = this.checkAllAll();
            if (bl == null) {
                this.base = this.allb;
                this.derived = this.alld;
                this.cmb.testOccurrences(this.alld.calOccurs());
            }
            return bl;
        }
        this.dfab = (XSDFACM)this.base;
        bl = this.checkAllDFA();
        if (bl == null) {
            this.base = this.dfab;
            this.derived = this.alld;
            this.cmb.testOccurrences(this.alld.calOccurs());
        }
        return bl;
    }

    private Boolean checkAllEmpty() {
        int[] nArray = new int[]{-1};
        if (this.base.nextWildcardTransition(this.b, this.bn, nArray) != null) {
            this.base = new XS11AllCM(false, 0, null, ((XSEmptyCM)this.base).getOpenContent());
            return null;
        }
        return this.derived.nextElementTransition(this.d, this.dn, nArray) == null && this.derived.nextWildcardTransition(this.d, this.dn, nArray) == null;
    }

    private Boolean checkAllAll() {
        Object[] objectArray;
        if (this.allb.getOpenContent() != null && this.allb.getOpenContent().fMode == 2 && this.alld.getOpenContent() != null && this.alld.getOpenContent().fMode == 1) {
            return null;
        }
        if (this.siblingsD == null) {
            this.getDerivedSiblings();
        }
        if (this.alld.hasOptionalContent()) {
            if (!this.checkOptionalContent()) {
                return Boolean.FALSE;
            }
        } else if (this.allb.hasOptionalContent()) {
            return null;
        }
        int[] nArray = this.derived.startContentModel();
        int[] nArray2 = this.base.startContentModel();
        this.indexd[0] = -1;
        while ((this.ed = this.derived.nextElementTransition(this.d, this.dn, this.indexd)) != null) {
            nArray[this.indexd[0]] = -1;
            this.matchedHead = false;
            if (!this.matchEE(nArray, nArray2)) {
                return Boolean.FALSE;
            }
            if (this.matchedHead || this.ed.getScope() != 1) continue;
            objectArray = this.sgh.getSubstitutionGroup(this.ed, (short)4);
            for (int i = 0; i < objectArray.length; ++i) {
                this.ed = objectArray[i];
                if (this.matchEE(nArray, nArray2)) continue;
                return Boolean.FALSE;
            }
        }
        this.wDNList.clear();
        this.wDNList.addAll(this.siblingsD);
        this.indexd[0] = -1;
        while ((this.wd = this.derived.nextWildcardTransition(this.d, this.dn, this.indexd)) != null) {
            if (this.matchWE(nArray2)) continue;
            return Boolean.FALSE;
        }
        objectArray = this.base.startContentModel();
        int[] nArray3 = this.base.startContentModel();
        this.indexd[0] = -1;
        while ((this.ed = this.derived.nextElementTransition(this.d, this.dn, this.indexd)) != null) {
            this.indexb[0] = nArray[this.indexd[0]];
            if (this.indexb[0] < 0) continue;
            this.alld.collectOccurs((int[])objectArray, nArray3, this.indexb[0], this.indexd[0]);
        }
        this.allb = this.allb.copy();
        this.alld = this.alld.copy();
        if (!this.allb.removeAsBase((int[])objectArray, nArray3, nArray2)) {
            return Boolean.FALSE;
        }
        this.alld.removeAsDerived(nArray3, nArray2, nArray);
        return null;
    }

    private boolean checkOptionalContent() {
        int n;
        XSWildcardDecl xSWildcardDecl;
        int n2 = this.allb.totalMin();
        if (!this.allb.hasOptionalContent() && n2 != 0) {
            return false;
        }
        XSOpenContentDecl xSOpenContentDecl = this.alld.getOpenContent();
        XSWildcardDecl xSWildcardDecl2 = this.wd = xSOpenContentDecl == null ? null : xSOpenContentDecl.fWildcard;
        if (this.wd == null) {
            return true;
        }
        this.wDNList.clear();
        this.wDNList.addAll(this.siblingsD);
        this.copyDerivedWildcard();
        int[] nArray = new int[]{-1};
        while (!this.emptyWildcard() && (xSWildcardDecl = this.derived.nextWildcardTransition(this.d, this.dn, nArray)) != null) {
            if (xSWildcardDecl == this.wd) continue;
            this.subtractWildcard(xSWildcardDecl, true);
        }
        if (this.emptyWildcard()) {
            return true;
        }
        this.indexb[0] = -1;
        block1: while ((this.eb = this.base.nextElementTransition(this.b, this.bn, this.indexb)) != null) {
            n = this.allb.min(this.indexb[0]);
            if (this.allowName(this.eb.fTargetNamespace, this.eb.fName)) {
                if (n <= 1 && n >= n2) continue;
                return false;
            }
            if (this.eb.getScope() != 1) continue;
            XSElementDecl[] xSElementDeclArray = this.sgh.getSubstitutionGroup(this.eb, (short)4);
            for (int i = 0; i < xSElementDeclArray.length; ++i) {
                this.eb = xSElementDeclArray[i];
                if (!this.allowName(this.eb.fTargetNamespace, this.eb.fName)) continue;
                if (n <= 1 && n >= n2) continue block1;
                return false;
            }
        }
        this.indexb[0] = -1;
        while ((this.wb = this.base.nextWildcardTransition(this.b, this.bn, this.indexb)) != null) {
            if (this.base.isOpenContent(this.wb) || !this.overlap() || (n = this.allb.min(this.indexb[0])) <= 1 && n >= n2) continue;
            return false;
        }
        return true;
    }

    private boolean overlap() {
        int n = 0;
        while (n < this.wANList.size()) {
            this.qname.uri = (String)this.wANList.get(n++);
            this.qname.localpart = (String)this.wANList.get(n++);
            if (!this.base.allowExpandedName(this.wb, this.qname, this.sgh, this)) continue;
            return true;
        }
        if (this.wType == 1 || this.wb.fType == 1 || this.wType == 2 && this.wb.fType == 2) {
            return true;
        }
        if (this.wType == 3 && this.wb.fType == 3) {
            for (n = 0; n < this.wb.fNamespaceList.length; ++n) {
                if (!this.wNSList.contains(this.wb.fNamespaceList[n])) continue;
                return true;
            }
            return false;
        }
        if (this.wType == 2) {
            for (n = 0; n < this.wb.fNamespaceList.length; ++n) {
                if (this.wNSList.contains(this.wb.fNamespaceList[n])) continue;
                return true;
            }
            return false;
        }
        for (n = 0; n < this.wNSList.size(); ++n) {
            int n2;
            String string = (String)this.wNSList.get(n);
            for (n2 = 0; !(n2 >= this.wb.fNamespaceList.length || string == null && this.wb.fNamespaceList[n2] == null || string != null && string.equals(this.wb.fNamespaceList[n2])); ++n2) {
            }
            if (n2 != this.wb.fNamespaceList.length) continue;
            return true;
        }
        return false;
    }

    private boolean matchEE(int[] nArray, int[] nArray2) {
        int n = this.indexd[0];
        this.indexb[0] = -1;
        while ((this.eb = this.base.nextElementTransition(this.b, this.bn, this.indexb)) != null) {
            int n2 = this.indexb[0];
            if (this.eb.getName() == this.ed.getName() && this.eb.getNamespace() == this.ed.getNamespace()) {
                if (nArray[n] != -1 && nArray[n] != n2) {
                    nArray2[nArray[n]] = -1;
                    nArray2[n2] = -1;
                    return true;
                }
                if (nArray2[n2] < 0) {
                    nArray[n] = n2;
                    return true;
                }
                if (nArray[n] == -1) {
                    nArray[n] = n2;
                    int n3 = n2;
                    nArray2[n3] = nArray2[n3] + 1;
                }
                this.matchedHead = this.eb == this.ed;
                return this.checkEERestriction();
            }
            XSElementDecl[] xSElementDeclArray = this.sgh.getSubstitutionGroup(this.eb, (short)4);
            for (int i = 0; i < xSElementDeclArray.length; ++i) {
                if (xSElementDeclArray[i].getName() != this.ed.getName() || xSElementDeclArray[i].getNamespace() != this.ed.getNamespace()) continue;
                if (nArray[n] != -1 && nArray[n] != n2) {
                    if (nArray[n] >= 0) {
                        nArray2[nArray[n]] = -1;
                    }
                    nArray2[n2] = -1;
                    return true;
                }
                if (nArray2[n2] < 0) {
                    nArray[n] = n2;
                    return true;
                }
                if (nArray[n] == -1) {
                    nArray[n] = n2;
                    int n4 = n2;
                    nArray2[n4] = nArray2[n4] + 1;
                }
                this.eb = xSElementDeclArray[i];
                return this.checkEERestriction();
            }
        }
        if (nArray[n] >= 0) {
            nArray2[nArray[n]] = -1;
        }
        nArray[n] = -2;
        return true;
    }

    private boolean matchWE(int[] nArray) {
        this.indexb[0] = -1;
        while ((this.eb = this.base.nextElementTransition(this.b, this.bn, this.indexb)) != null) {
            int n = this.indexb[0];
            if (nArray[n] <= 0) continue;
            Boolean bl = this.checkWERestriction();
            if (bl != null) {
                if (!bl.booleanValue()) {
                    return false;
                }
                nArray[n] = -1;
                return true;
            }
            if (this.eb.getScope() != 1) continue;
            XSElementDecl[] xSElementDeclArray = this.sgh.getSubstitutionGroup(this.eb, (short)4);
            for (int i = 0; i < xSElementDeclArray.length; ++i) {
                this.eb = xSElementDeclArray[i];
                bl = this.checkWERestriction();
                if (bl == null) continue;
                if (!bl.booleanValue()) {
                    return false;
                }
                nArray[n] = -1;
                return true;
            }
        }
        return true;
    }

    private Boolean checkAllDFA() {
        return null;
    }

    private static class StatePair {
        private final int[] states;

        public StatePair(int[] nArray, int[] nArray2) {
            this.states = new int[nArray.length + nArray2.length];
            System.arraycopy(nArray, 0, this.states, 0, nArray.length);
            System.arraycopy(nArray2, 0, this.states, this.states.length - nArray2.length, nArray2.length);
        }

        private void set(int[] nArray, int[] nArray2) {
            System.arraycopy(nArray, 0, this.states, 0, nArray.length);
            System.arraycopy(nArray2, 0, this.states, this.states.length - nArray2.length, nArray2.length);
        }

        private void getStates(int[] nArray, int[] nArray2) {
            System.arraycopy(this.states, 0, nArray, 0, nArray.length);
            System.arraycopy(this.states, this.states.length - nArray2.length, nArray2, 0, nArray2.length);
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.states.length; ++i) {
                n = n * 7 + this.states[i];
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof StatePair)) {
                return false;
            }
            StatePair statePair = (StatePair)object;
            return Arrays.equals(this.states, statePair.states);
        }
    }

    static interface XS11CM
    extends XSCMValidator {
        public XSElementDecl nextElementTransition(int[] var1, int[] var2, int[] var3);

        public XSWildcardDecl nextWildcardTransition(int[] var1, int[] var2, int[] var3);

        public boolean isOpenContent(XSWildcardDecl var1);

        public boolean allowExpandedName(XSWildcardDecl var1, QName var2, SubstitutionGroupHandler var3, XSElementDeclHelper var4);

        public List getDefinedNames(SubstitutionGroupHandler var1);

        public void optimizeStates(XS11CM var1, int[] var2, int[] var3, int var4);
    }
}

