/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSElementDeclHelper;
import org.apache.xerces.impl.xs.XSOpenContentDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.models.XS11CMRestriction;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.XSObject;

public class XS11AllCM
implements XSCMValidator,
XS11CMRestriction.XS11CM {
    private static final short STATE_START = 0;
    private static final short STATE_CHILD = 1;
    private static final short STATE_SUFFIX = 2;
    private final boolean fHasOptionalContent;
    private final XSElementDecl[] fElements;
    private final XSWildcardDecl[] fWildcards;
    private final int[] fMinOccurs;
    private final int[] fMaxOccurs;
    private final int fNumElements;
    private final int fNumTotal;
    private final XSOpenContentDecl fOpenContent;

    public XS11AllCM(boolean bl, int n, XSParticleDecl[] xSParticleDeclArray, XSOpenContentDecl xSOpenContentDecl) {
        int n2;
        this.fHasOptionalContent = bl;
        int n3 = 1;
        for (n2 = 0; n2 < n; ++n2) {
            if (xSParticleDeclArray[n2].fType != 1) continue;
            ++n3;
        }
        this.fNumElements = n3;
        this.fNumTotal = n + 1;
        this.fElements = n3 > 1 ? new XSElementDecl[n3] : null;
        this.fWildcards = this.fNumTotal > n3 ? new XSWildcardDecl[this.fNumTotal] : null;
        if (this.fNumTotal > 1) {
            this.fMinOccurs = new int[this.fNumTotal];
            this.fMaxOccurs = new int[this.fNumTotal];
        } else {
            this.fMinOccurs = null;
            this.fMaxOccurs = null;
        }
        n2 = n3;
        n3 = 1;
        for (int i = 0; i < n; ++i) {
            XSParticleDecl xSParticleDecl = xSParticleDeclArray[i];
            if (xSParticleDecl.fType == 1) {
                this.fElements[n3] = (XSElementDecl)xSParticleDecl.fValue;
                this.fMinOccurs[n3] = xSParticleDecl.fMinOccurs;
                this.fMaxOccurs[n3] = xSParticleDecl.fMaxOccurs;
                ++n3;
                continue;
            }
            this.fWildcards[n2] = (XSWildcardDecl)xSParticleDecl.fValue;
            this.fMinOccurs[n2] = xSParticleDecl.fMinOccurs;
            this.fMaxOccurs[n2] = xSParticleDecl.fMaxOccurs;
            ++n2;
        }
        this.fOpenContent = xSOpenContentDecl;
    }

    public int[] startContentModel() {
        int[] nArray = new int[this.fNumTotal];
        for (int i = 0; i < this.fNumTotal; ++i) {
            nArray[i] = 0;
        }
        return nArray;
    }

    Object findMatchingDecl(QName qName, SubstitutionGroupHandler substitutionGroupHandler) {
        XSElementDecl xSElementDecl = this.findMatchingElemDecl(qName, substitutionGroupHandler);
        if (xSElementDecl != null) {
            return xSElementDecl;
        }
        for (int i = this.fNumElements; i < this.fNumTotal; ++i) {
            if (!this.fWildcards[i].allowQName(qName)) continue;
            return this.fWildcards[i];
        }
        return null;
    }

    public XSElementDecl findMatchingElemDecl(QName qName, SubstitutionGroupHandler substitutionGroupHandler) {
        for (int i = 1; i < this.fNumElements; ++i) {
            XSElementDecl xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fElements[i], (short)4);
            if (xSElementDecl == null) continue;
            return xSElementDecl;
        }
        return null;
    }

    public boolean allowExpandedName(XSWildcardDecl xSWildcardDecl, QName qName, SubstitutionGroupHandler substitutionGroupHandler, XSElementDeclHelper xSElementDeclHelper) {
        if (xSWildcardDecl.allowQName(qName)) {
            if (xSWildcardDecl.fDisallowedSibling && this.findMatchingElemDecl(qName, substitutionGroupHandler) != null) {
                return false;
            }
            return !xSWildcardDecl.fDisallowedDefined || xSElementDeclHelper.getGlobalElementDecl(qName) == null;
        }
        return false;
    }

    public Object oneTransition(QName qName, int[] nArray, SubstitutionGroupHandler substitutionGroupHandler, XSElementDeclHelper xSElementDeclHelper) {
        int n;
        if (nArray[0] < 0) {
            nArray[0] = -2;
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        if (nArray[0] == 2) {
            if (this.allowExpandedName(this.fOpenContent.fWildcard, qName, substitutionGroupHandler, xSElementDeclHelper)) {
                return this.fOpenContent;
            }
            nArray[0] = -1;
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        nArray[0] = 1;
        for (n = 1; n < this.fNumElements; ++n) {
            XSElementDecl xSElementDecl;
            if (nArray[n] == this.fMaxOccurs[n] || (xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fElements[n], (short)4)) == null) continue;
            int n2 = n;
            nArray[n2] = nArray[n2] + 1;
            return xSElementDecl;
        }
        for (n = this.fNumElements; n < this.fNumTotal; ++n) {
            if (nArray[n] == this.fMaxOccurs[n] || !this.allowExpandedName(this.fWildcards[n], qName, substitutionGroupHandler, xSElementDeclHelper)) continue;
            int n3 = n;
            nArray[n3] = nArray[n3] + 1;
            return this.fWildcards[n];
        }
        if (this.fOpenContent != null) {
            if (this.fOpenContent.fMode == 2) {
                if (this.isFinal(nArray)) {
                    nArray[0] = 2;
                } else {
                    nArray[0] = -1;
                    return this.findMatchingDecl(qName, substitutionGroupHandler);
                }
            }
            if (this.allowExpandedName(this.fOpenContent.fWildcard, qName, substitutionGroupHandler, xSElementDeclHelper)) {
                return this.fOpenContent;
            }
        }
        nArray[0] = -1;
        return this.findMatchingDecl(qName, substitutionGroupHandler);
    }

    public boolean endContentModel(int[] nArray) {
        int n = nArray[0];
        if (n == -1 || n == -2) {
            return false;
        }
        return this.isFinal(nArray);
    }

    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler substitutionGroupHandler, XSConstraints xSConstraints) throws XMLSchemaException {
        int n;
        int n2;
        for (n2 = 1; n2 < this.fNumElements; ++n2) {
            for (n = n2 + 1; n < this.fNumElements; ++n) {
                if (!xSConstraints.overlapUPA((Object)this.fElements[n2], (Object)this.fElements[n], substitutionGroupHandler)) continue;
                throw new XMLSchemaException("cos-nonambig", new Object[]{this.fElements[n2].toString(), this.fElements[n].toString()});
            }
        }
        for (n2 = this.fNumElements; n2 < this.fNumTotal; ++n2) {
            for (n = n2 + 1; n < this.fNumTotal; ++n) {
                if (!xSConstraints.overlapUPA(this.fWildcards[n2], this.fWildcards[n])) continue;
                throw new XMLSchemaException("cos-nonambig", new Object[]{this.fWildcards[n2].toString(), this.fWildcards[n].toString()});
            }
        }
        return false;
    }

    public Vector whatCanGoHere(int[] nArray) {
        int n;
        Vector<XSObject> vector = new Vector<XSObject>();
        for (n = 1; n < this.fNumElements; ++n) {
            if (nArray[n] != 0 && nArray[n] >= this.fMaxOccurs[n]) continue;
            vector.addElement(this.fElements[n]);
        }
        if (vector.size() == 0) {
            for (n = this.fNumElements; n < this.fNumTotal; ++n) {
                if (nArray[n] != 0 && nArray[n] >= this.fMaxOccurs[n]) continue;
                vector.addElement(this.fWildcards[n]);
            }
        }
        if (vector.size() == 0 && this.fOpenContent != null) {
            vector.add(this.fOpenContent);
        }
        return vector;
    }

    public int[] occurenceInfo(int[] nArray) {
        return null;
    }

    public String getTermName(int n) {
        return null;
    }

    public boolean isCompactedForUPA() {
        return false;
    }

    private boolean isFinal(int[] nArray) {
        if (this.fHasOptionalContent && nArray[0] == 0 || nArray[0] == 2) {
            return true;
        }
        for (int i = 1; i < this.fNumTotal; ++i) {
            if (nArray[i] >= this.fMinOccurs[i]) continue;
            return false;
        }
        return true;
    }

    public XSElementDecl nextElementTransition(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int n2 = n = nArray3[0] == -1 ? 1 : nArray3[0] + 1;
        while (n < this.fNumElements) {
            if (this.isAllowedTransition(nArray, nArray2, n)) {
                nArray3[0] = n;
                return this.fElements[n];
            }
            ++n;
        }
        nArray3[0] = -1;
        return null;
    }

    public XSWildcardDecl nextWildcardTransition(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int n2 = n = nArray3[0] == -1 ? this.fNumElements : nArray3[0] + 1;
        while (n < this.fNumTotal) {
            if (this.isAllowedTransition(nArray, nArray2, n)) {
                nArray3[0] = n;
                return this.fWildcards[n];
            }
            ++n;
        }
        if (n == this.fNumTotal && this.isOpenContentAllowed(nArray, nArray2)) {
            nArray3[0] = this.fNumTotal;
            return this.fOpenContent.fWildcard;
        }
        nArray3[0] = -1;
        return null;
    }

    private boolean isAllowedTransition(int[] nArray, int[] nArray2, int n) {
        if (nArray[0] == 2) {
            return false;
        }
        if (nArray[n] == this.fMaxOccurs[n]) {
            return false;
        }
        if (nArray2 != null) {
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray2[0] = 1;
            if (nArray2[n] == 0 || nArray2[n] < this.fMinOccurs[n] || this.fMaxOccurs[n] != -1) {
                int n2 = n;
                nArray2[n2] = nArray2[n2] + 1;
            }
        }
        return true;
    }

    private boolean isOpenContentAllowed(int[] nArray, int[] nArray2) {
        if (this.fOpenContent == null) {
            return false;
        }
        if (this.fOpenContent.fMode == 2) {
            if (this.isFinal(nArray)) {
                nArray2[0] = 2;
                return true;
            }
            return false;
        }
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return true;
    }

    public boolean isOpenContent(XSWildcardDecl xSWildcardDecl) {
        return this.fOpenContent != null && this.fOpenContent.fWildcard == xSWildcardDecl;
    }

    public List getDefinedNames(SubstitutionGroupHandler substitutionGroupHandler) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i < this.fNumElements; ++i) {
            XSElementDecl xSElementDecl = this.fElements[i];
            arrayList.add(xSElementDecl.fTargetNamespace);
            arrayList.add(xSElementDecl.fName);
            if (xSElementDecl.fScope != 1) continue;
            XSElementDecl[] xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl, (short)4);
            for (int j = 0; j < xSElementDeclArray.length; ++j) {
                arrayList.add(xSElementDeclArray[j].fTargetNamespace);
                arrayList.add(xSElementDeclArray[j].fName);
            }
        }
        return arrayList;
    }

    public void optimizeStates(XS11CMRestriction.XS11CM xS11CM, int[] nArray, int[] nArray2, int n) {
    }

    private XS11AllCM(boolean bl, XSElementDecl[] xSElementDeclArray, XSWildcardDecl[] xSWildcardDeclArray, int[] nArray, int[] nArray2, int n, int n2, XSOpenContentDecl xSOpenContentDecl) {
        this.fHasOptionalContent = bl;
        this.fElements = xSElementDeclArray;
        this.fWildcards = xSWildcardDeclArray;
        this.fMinOccurs = nArray;
        this.fMaxOccurs = nArray2;
        this.fNumElements = n;
        this.fNumTotal = n2;
        this.fOpenContent = xSOpenContentDecl;
    }

    XS11AllCM copy() {
        int[] nArray;
        int[] nArray2;
        if (this.fNumTotal > 1) {
            nArray2 = new int[this.fNumTotal];
            nArray = new int[this.fNumTotal];
            System.arraycopy(this.fMinOccurs, 0, nArray2, 0, this.fNumTotal);
            System.arraycopy(this.fMaxOccurs, 0, nArray, 0, this.fNumTotal);
        } else {
            nArray2 = null;
            nArray = null;
        }
        return new XS11AllCM(this.fHasOptionalContent, this.fElements, this.fWildcards, nArray2, nArray, this.fNumElements, this.fNumTotal, this.fOpenContent);
    }

    void collectOccurs(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = n;
        nArray[n3] = nArray[n3] + this.fMinOccurs[n2];
        if (nArray2[n] != -1) {
            if (this.fMaxOccurs[n2] == -1) {
                nArray2[n] = -1;
            } else {
                int n4 = n;
                nArray2[n4] = nArray2[n4] + this.fMaxOccurs[n2];
            }
        }
    }

    boolean removeAsBase(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 1; i < this.fNumElements; ++i) {
            if (this.fMinOccurs[i] > nArray[i]) {
                return false;
            }
            this.fMinOccurs[i] = 0;
            if (this.fMaxOccurs[i] != -1) {
                if (nArray2[i] == -1 || this.fMaxOccurs[i] < nArray2[i]) {
                    if (nArray3[i] > 1) {
                        nArray3[i] = -1;
                        continue;
                    }
                    if (nArray2[i] != -1) {
                        int n = i;
                        nArray2[n] = nArray2[n] - this.fMaxOccurs[i];
                    }
                    this.fMaxOccurs[i] = 0;
                    continue;
                }
                int n = i;
                this.fMaxOccurs[n] = this.fMaxOccurs[n] - nArray2[i];
                nArray2[i] = 0;
                continue;
            }
            if (nArray2[i] == -1) {
                this.fMaxOccurs[i] = 0;
            }
            nArray2[i] = 0;
        }
        return true;
    }

    void removeAsDerived(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 1; i < this.fNumElements; ++i) {
            int n = nArray3[i];
            if (n < 0 || nArray2[n] < 0) continue;
            this.fMinOccurs[i] = 0;
            this.fMaxOccurs[i] = nArray[n];
        }
    }

    int minOccurs(int n) {
        return this.fMinOccurs[n];
    }

    int maxOccurs(int n) {
        return this.fMaxOccurs[n];
    }

    boolean isUnbounded(int n) {
        return n < this.fNumTotal ? this.fMaxOccurs[n] == -1 : true;
    }

    boolean hasOptionalContent() {
        return this.fHasOptionalContent;
    }

    int totalMin() {
        int n = 0;
        for (int i = 1; i < this.fNumTotal; ++i) {
            n += this.fMinOccurs[i];
        }
        return n;
    }

    int min(int n) {
        return this.fMinOccurs[n];
    }

    XSOpenContentDecl getOpenContent() {
        return this.fOpenContent;
    }

    int calOccurs() {
        long l = 1L;
        for (int i = 1; i < this.fNumTotal; ++i) {
            int n = this.fMaxOccurs[i];
            if (n == 0) continue;
            if (n == -1) {
                int n2 = n = this.fMinOccurs[i] == 0 ? 1 : this.fMinOccurs[i];
            }
            if ((l *= (long)(n + 1)) <= Integer.MAX_VALUE) continue;
            return -1;
        }
        return (int)l;
    }
}

