/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.expathrepo;

import java.io.InputStream;
import java.util.Optional;
import javax.xml.transform.stream.StreamSource;
import org.exist.dom.QName;
import org.exist.repo.ExistRepository;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Cardinality;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Base64BinaryDocument;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Packages;
import org.expath.pkg.repo.Storage;

public class GetResource
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-resource", "http://exist-db.org/xquery/repo", "repo"), "Retrieves the specified resource from an installed expath application package.", new SequenceType[]{new FunctionParameterSequenceType("pkgName", 22, Cardinality.EXACTLY_ONE, "package name"), new FunctionParameterSequenceType("resource", 22, Cardinality.EXACTLY_ONE, "resource path")}, (SequenceType)new FunctionReturnSequenceType(26, Cardinality.ZERO_OR_ONE, "<status result=\"ok\"/> if deployment was ok. Throws an error otherwise."));

    public GetResource(XQueryContext context) {
        super(context, signature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String pkgName = args[0].getStringValue();
        String path = args[1].getStringValue();
        Optional repo = this.context.getRepository();
        if (!repo.isPresent()) throw new XPathException("expath repository not available");
        try {
            for (Packages pp : ((ExistRepository)repo.get()).getParentRepo().listPackages()) {
                Package pkg = pp.latest();
                if (!pkg.getName().equals(pkgName)) continue;
                try {
                    StreamSource source = (StreamSource)pkg.getResolver().resolveResource(path);
                    return Base64BinaryDocument.getInstance((BinaryValueManager)this.context, (InputStream)source.getInputStream());
                }
                catch (Storage.NotExistException e) {
                    throw new XPathException(ErrorCodes.FODC0002, "Resource " + path + " does not exist.", (Throwable)e);
                    return Sequence.EMPTY_SEQUENCE;
                }
            }
        }
        catch (PackageException e) {
            throw new XPathException((Expression)this, ErrorCodes.FOER0000, "Caught package error while reading expath package");
        }
    }
}

