/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.expathrepo;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.repo.ExistRepository;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Cardinality;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Repository;
import org.expath.pkg.repo.UserInteractionStrategy;
import org.expath.pkg.repo.tui.BatchUserInteraction;

public class RemoveFunction
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(RemoveFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("remove", "http://exist-db.org/xquery/repo", "repo"), "Remove package, pkgName, from repository.", new SequenceType[]{new FunctionParameterSequenceType("pkgName", 22, Cardinality.EXACTLY_ONE, "package name")}, (SequenceType)new FunctionReturnSequenceType(23, Cardinality.EXACTLY_ONE, "true if successful, false otherwise"));

    public RemoveFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        BooleanValue removed = BooleanValue.TRUE;
        boolean force = false;
        BatchUserInteraction interact = new BatchUserInteraction();
        String pkg = args[0].getStringValue();
        try {
            Optional repo = this.getContext().getRepository();
            if (!repo.isPresent()) {
                throw new XPathException("expath repository not available");
            }
            Repository parent_repo = ((ExistRepository)repo.get()).getParentRepo();
            parent_repo.removePackage(pkg, force, (UserInteractionStrategy)interact);
            ((ExistRepository)repo.get()).reportAction(ExistRepository.Action.UNINSTALL, pkg);
            this.context.getBroker().getBrokerPool().getXQueryPool().clear();
        }
        catch (XPathException | PackageException pe) {
            return BooleanValue.FALSE;
        }
        return removed;
    }
}

