/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.expathrepo;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.storage.BrokerPool;
import org.exist.storage.txn.Txn;
import org.expath.pkg.repo.XarSource;

class BinaryDocumentXarSource
implements XarSource {
    private final BrokerPool pool;
    final Txn transaction;
    private final BinaryDocument binaryDocument;

    public BinaryDocumentXarSource(BrokerPool pool, Txn transaction, BinaryDocument binaryDocument) {
        this.pool = pool;
        this.transaction = transaction;
        this.binaryDocument = binaryDocument;
    }

    public URI getURI() {
        try {
            return new URI(this.binaryDocument.getURI().toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isValid() {
        return true;
    }

    public InputStream newInputStream() throws IOException {
        return this.pool.getBlobStore().get(this.transaction, this.binaryDocument.getBlobId());
    }
}

