/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.expathrepo;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.repo.ExistRepository;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.expath.pkg.repo.Packages;
import org.expath.pkg.repo.Repository;

public class ListFunction
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(ListFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("list", "http://exist-db.org/xquery/repo", "repo"), "List repository packages.", null, (SequenceType)new FunctionReturnSequenceType(22, 7, "sequence of strings"));

    public ListFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        ValueSequence result = new ValueSequence();
        Optional repo = this.getContext().getRepository();
        if (repo.isPresent()) {
            try {
                Repository parent_repo = ((ExistRepository)repo.get()).getParentRepo();
                for (Packages pkg : parent_repo.listPackages()) {
                    String name = pkg.name();
                    result.add((Item)new StringValue(name));
                }
            }
            catch (Exception ex) {
                throw new XPathException("Problem listing packages in expath repository ", (Throwable)ex);
            }
            return result;
        }
        throw new XPathException("expath repository not available");
    }
}

