/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.expathrepo;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.LockedDocument;
import org.exist.repo.ClasspathHelper;
import org.exist.repo.ExistPkgInfo;
import org.exist.repo.ExistRepository;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.BrokerPool;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.expathrepo.BinaryDocumentXarSource;
import org.exist.xquery.modules.expathrepo.EXPathErrorCode;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Repository;
import org.expath.pkg.repo.UserInteractionStrategy;
import org.expath.pkg.repo.XarSource;
import org.expath.pkg.repo.tui.BatchUserInteraction;

public class InstallFunction
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(InstallFunction.class);
    public static final FunctionSignature signatureInstall = new FunctionSignature(new QName("install", "http://exist-db.org/xquery/repo", "repo"), "Install package from repository.", new SequenceType[]{new FunctionParameterSequenceType("pkgName", 22, 2, "package name")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true if successful, false otherwise"));
    public static final FunctionSignature signatureInstallFromDB = new FunctionSignature(new QName("install-from-db", "http://exist-db.org/xquery/repo", "repo"), "Install package stored in database.", new SequenceType[]{new FunctionParameterSequenceType("path", 22, 2, "database path to the package archive (.xar file)")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true if successful, false otherwise"));

    public InstallFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        BooleanValue removed = BooleanValue.FALSE;
        boolean force = true;
        BatchUserInteraction interact = new BatchUserInteraction();
        String pkgOrPath = args[0].getStringValue();
        Optional repo = this.getContext().getRepository();
        try {
            if (repo.isPresent()) {
                Package pkg;
                Repository parent_repo = ((ExistRepository)repo.get()).getParentRepo();
                if (this.isCalledAs("install")) {
                    URI uri = this._getURI(pkgOrPath);
                    pkg = parent_repo.installPackage(uri, force, (UserInteractionStrategy)interact);
                    ((ExistRepository)repo.get()).reportAction(ExistRepository.Action.INSTALL, pkg.getName());
                } else {
                    try (LockedDocument lockedDoc = this.getBinaryDoc(pkgOrPath);
                         Txn transaction = this.context.getBroker().continueOrBeginTransaction();){
                        DocumentImpl doc = lockedDoc.getDocument();
                        LOG.debug("Installing file: " + doc.getURI());
                        pkg = parent_repo.installPackage((XarSource)new BinaryDocumentXarSource(this.context.getBroker().getBrokerPool(), transaction, (BinaryDocument)doc), force, (UserInteractionStrategy)interact);
                        ((ExistRepository)repo.get()).reportAction(ExistRepository.Action.INSTALL, pkg.getName());
                        transaction.commit();
                    }
                }
                ExistPkgInfo info = (ExistPkgInfo)pkg.getInfo("exist");
                if (info != null && !info.getJars().isEmpty()) {
                    ClasspathHelper.updateClasspath((BrokerPool)this.context.getBroker().getBrokerPool(), (Package)pkg);
                }
            } else {
                throw new XPathException("expath repository not available");
            }
            this.context.getBroker().getBrokerPool().getXQueryPool().clear();
            removed = BooleanValue.TRUE;
        }
        catch (TransactionException | PackageException ex) {
            logger.error(ex.getMessage(), ex);
            return removed;
        }
        catch (XPathException xpe) {
            logger.error(xpe.getMessage());
            return removed;
        }
        return removed;
    }

    private URI _getURI(String s) throws XPathException {
        URI uri;
        try {
            uri = new URI(s);
        }
        catch (URISyntaxException ex) {
            throw new XPathException((Expression)this, EXPathErrorCode.EXPDY001, s + " is not a valid URI: " + ex.getMessage(), (Sequence)new StringValue(s), (Throwable)ex);
        }
        if (uri.isAbsolute()) {
            return uri;
        }
        throw new XPathException((Expression)this, EXPathErrorCode.EXPDY001, s + " must be an absolute URI", (Sequence)new StringValue(s));
    }

    private LockedDocument getBinaryDoc(String path) throws XPathException {
        try {
            XmldbURI uri = XmldbURI.createInternal((String)path);
            LockedDocument lockedDoc = this.context.getBroker().getXMLResource(uri, Lock.LockMode.READ_LOCK);
            if (lockedDoc == null) {
                throw new XPathException((Expression)this, EXPathErrorCode.EXPDY001, path + " is not .xar resource", (Sequence)new StringValue(path));
            }
            if (lockedDoc.getDocument().getResourceType() != 1) {
                lockedDoc.close();
                throw new XPathException((Expression)this, EXPathErrorCode.EXPDY001, path + " is not a valid .xar, it's not a binary resource", (Sequence)new StringValue(path));
            }
            return lockedDoc;
        }
        catch (PermissionDeniedException e) {
            throw new XPathException((Expression)this, EXPathErrorCode.EXPDY003, e.getMessage(), (Sequence)new StringValue(path), (Throwable)e);
        }
    }
}

