/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.parser;

import com.greenpineyu.fel.common.ReflectUtil;
import com.greenpineyu.fel.compile.InterpreterSourceBuilder;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.AbstractContext;
import com.greenpineyu.fel.context.ArrayCtx;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.parser.AbstFelNode;
import com.greenpineyu.fel.parser.FelNode;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarAstNode
extends AbstFelNode {
    private final String text;

    public VarAstNode(Token token) {
        super(token);
        this.builder = new SourceBuilder(){

            @Override
            public String source(FelContext ctx, FelNode node) {
                if (!node.isDefaultInterpreter()) {
                    return InterpreterSourceBuilder.getInstance().source(ctx, node);
                }
                Class<?> type = this.returnType(ctx, node);
                String varName = node.getText();
                String getVarCode = "context.get(\"" + varName + "\")";
                if (ctx instanceof ArrayCtx) {
                    ArrayCtx c = (ArrayCtx)ctx;
                    getVarCode = "((context instanceof ArrayCtx)?((ArrayCtx)context).get(" + c.getIndex(varName) + "):context.get(\"" + varName + "\"))";
                }
                String code = VarAstNode.getVarFullCode(type, getVarCode);
                return code;
            }

            @Override
            public Class<?> returnType(FelContext ctx, FelNode node) {
                Class<?> type = AbstractContext.getVarType(node.getText(), ctx);
                if (type == null) {
                    type = InterpreterSourceBuilder.getInstance().returnType(ctx, node);
                }
                return type;
            }
        };
        this.text = token.getText();
    }

    public String getText() {
        return this.text;
    }

    @Override
    public Object interpret(FelContext context, FelNode node) {
        return context.get(this.text);
    }

    public static boolean isVar(FelNode n) {
        if (n == null) {
            return false;
        }
        boolean isVar = n instanceof VarAstNode;
        if (isVar && n instanceof CommonTree) {
            CommonTree treeNode = (CommonTree)n;
            CommonTree p = treeNode.parent;
            if (p != null && ".".equals(p.getText())) {
                isVar = p.getChildren().get(0) == n;
            }
        }
        return isVar;
    }

    public static String getVarFullCode(Class<?> type, String getVarCode) {
        String typeName = type.getCanonicalName();
        boolean isNumber = Number.class.isAssignableFrom(type);
        String code = "";
        code = ReflectUtil.isPrimitiveOrWrapNumber(type) ? "((" + typeName + ")" + getVarCode + ")" : (isNumber ? "((" + typeName + ")" + getVarCode + ").doubleValue()" : "((" + typeName + ")" + getVarCode + ")");
        return code;
    }
}

