/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function.operator;

import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.common.ReflectUtil;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.exception.CompileException;
import com.greenpineyu.fel.exception.EvalException;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.parser.FelNode;
import java.util.List;

public class Mul
extends StableFunction {
    public Object call(FelNode node, FelContext context) {
        List<FelNode> children = node.getChildren();
        if (children.size() == 2) {
            FelNode left = children.get(0);
            Object leftValue = left.eval(context);
            FelNode right = children.get(1);
            Object rightValue = right.eval(context);
            if (leftValue instanceof Number && rightValue instanceof Number) {
                double l = NumberUtil.toDouble(leftValue);
                double r = NumberUtil.toDouble(rightValue);
                return this.calc(l, r);
            }
            throw new EvalException("\u6267\u884c" + this.getName() + "\u51fa\u9519\uff0c\u53c2\u6570\u5fc5\u987b\u662f\u6570\u503c\u578b");
        }
        throw new EvalException("\u6267\u884c" + this.getName() + "\u51fa\u9519\uff0c\u53c2\u6570\u6570\u91cf\u5fc5\u987b\u4e3a2\u3002");
    }

    Object calc(double l, double r) {
        return NumberUtil.parseNumber(l * r);
    }

    public String getName() {
        return "*";
    }

    public FelMethod toMethod(FelNode node, FelContext ctx) {
        String code = "";
        FelNode left = node.getChildren().get(0);
        FelNode right = node.getChildren().get(1);
        SourceBuilder lm = left.toMethod(ctx);
        Class<?> leftType = lm.returnType(ctx, left);
        SourceBuilder rm = right.toMethod(ctx);
        Class<?> rightType = lm.returnType(ctx, right);
        Class<?> type = null;
        if (!ReflectUtil.isPrimitiveOrWrapNumber(leftType) || !ReflectUtil.isPrimitiveOrWrapNumber(rightType)) {
            throw new CompileException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b[" + ReflectUtil.getClassName(leftType) + "\u3001" + ReflectUtil.getClassName(rightType) + "]\u3002[" + this.getName() + "]\u8fd0\u7b97\u53ea\u652f\u6301\u6570\u503c\u7c7b\u578b");
        }
        type = NumberUtil.arithmeticClass(leftType, rightType);
        code = "(" + lm.source(ctx, left) + ")" + this.getName() + "(" + rm.source(ctx, right) + ")";
        FelMethod m = new FelMethod(type, code);
        return m;
    }

    public boolean stable() {
        return true;
    }
}

