/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.compile;

import com.greenpineyu.fel.Expression;
import com.greenpineyu.fel.compile.ConstExpSrc;
import com.greenpineyu.fel.compile.FelCompiler;
import com.greenpineyu.fel.compile.JavaSource;
import com.greenpineyu.fel.compile.SourceGenerator;
import com.greenpineyu.fel.compile.SourceGeneratorImpl;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.parser.FelNode;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileService {
    private SourceGenerator srcGen = new SourceGeneratorImpl();
    private FelCompiler complier;

    public CompileService() {
        FelCompiler comp;
        String name = this.getCompilerClassName();
        this.complier = comp = this.newCompiler(name);
    }

    public SourceGenerator getSrcGen() {
        return this.srcGen;
    }

    public void setSrcGen(SourceGenerator srcGen) {
        this.srcGen = srcGen;
    }

    public FelCompiler getComplier() {
        return this.complier;
    }

    public void setComplier(FelCompiler complier) {
        this.complier = complier;
    }

    public static List<String> getClassPath(ClassLoader cl) {
        ArrayList<String> paths = new ArrayList<String>();
        while (cl != null) {
            boolean isUrlClassloader = cl instanceof URLClassLoader;
            if (isUrlClassloader) {
                URLClassLoader urlClassLoader = (URLClassLoader)cl;
                URL[] uRLArray = urlClassLoader.getURLs();
                int n = uRLArray.length;
                int n2 = 0;
                while (n2 < n) {
                    URL url = uRLArray[n2];
                    paths.add(url.getFile());
                    ++n2;
                }
            } else {
                Enumeration<URL> resources = null;
                try {
                    resources = cl.getResources("/");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (resources != null) {
                    while (resources.hasMoreElements()) {
                        URL resource = resources.nextElement();
                        paths.add(resource.getFile());
                    }
                }
            }
            cl = cl.getParent();
        }
        return paths;
    }

    private FelCompiler newCompiler(String name) {
        FelCompiler comp = null;
        try {
            Class<?> cls = Class.forName(name);
            comp = (FelCompiler)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return comp;
    }

    private String getCompilerClassName() {
        String version = System.getProperty("java.version");
        String compileClassName = FelCompiler.class.getName();
        compileClassName = version != null && version.startsWith("1.5") ? String.valueOf(compileClassName) + "15" : String.valueOf(compileClassName) + "16";
        return compileClassName;
    }

    public Expression compile(FelContext ctx, FelNode node, String originalExp) {
        try {
            JavaSource src = this.srcGen.getSource(ctx, node);
            if (src instanceof ConstExpSrc) {
                ConstExpSrc s = (ConstExpSrc)src;
                return s.getValue();
            }
            src.setSource("// \u8868\u8fbe\u5f0f:" + originalExp + "\n" + src.getSource());
            return this.complier.compile(src);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        System.getProperties().list(System.out);
    }
}

