/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.compile;

import com.greenpineyu.fel.Expression;
import com.greenpineyu.fel.common.StringUtils;
import com.greenpineyu.fel.compile.CompileService;
import com.greenpineyu.fel.compile.FelCompiler;
import com.greenpineyu.fel.compile.FileClassLoader;
import com.greenpineyu.fel.compile.JavaSource;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstCompiler
implements FelCompiler {
    static final String CLASS_DIR;
    private String classpath4compile = this.classPathToString();
    private static final String BASE_DIR;
    static ClassLoader loader;
    private static ExecutorService exeService;

    static {
        String userDir = System.getProperty("user.dir");
        BASE_DIR = String.valueOf(userDir) + File.separator + "fel" + File.separator;
        CLASS_DIR = String.valueOf(BASE_DIR) + "classes" + File.separator;
        loader = new FileClassLoader(AbstCompiler.class.getClassLoader(), CLASS_DIR);
        AbstCompiler.createClassDir();
        exeService = AbstCompiler.initThreadPool();
    }

    static String getClassPackageDir(String pack) {
        return String.valueOf(CLASS_DIR) + AbstCompiler.packageToPath(pack) + File.separator;
    }

    protected String classPathToString() {
        List<String> paths = CompileService.getClassPath(this.getClass().getClassLoader());
        StringBuilder cpStr = new StringBuilder();
        for (String c : paths) {
            cpStr.append(String.valueOf(c) + File.pathSeparator);
        }
        return cpStr.toString();
    }

    static String getSrcPackageDir(String pack) {
        return String.valueOf(BASE_DIR) + "src" + File.separator + AbstCompiler.packageToPath(pack) + File.separator;
    }

    @Override
    public Expression compile(JavaSource src) {
        try {
            Class<Expression> compile = this.compileToClass(src);
            Expression expression = compile.newInstance();
            return expression;
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        finally {
            String className = src.getName();
            String pack = src.getPackageName();
            String srcPackageDir = AbstCompiler.getSrcPackageDir(pack);
            this.clean(srcPackageDir, AbstCompiler.getClassPackageDir(pack), className);
        }
        return null;
    }

    abstract Class<Expression> compileToClass(JavaSource var1) throws ClassNotFoundException;

    static void createClassDir() {
        new File(CLASS_DIR).mkdirs();
    }

    private static ExecutorService initThreadPool() {
        return new ThreadPoolExecutor(0, 10, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    void clean(final String srcPackageDir, final String classPackageDir, final String fileName) {
        if (exeService.isShutdown()) {
            exeService = AbstCompiler.initThreadPool();
        }
        exeService.execute(new Runnable(){

            public void run() {
                Thread.currentThread().setPriority(1);
                AbstCompiler.this.delFile(srcPackageDir, classPackageDir, fileName);
            }
        });
    }

    void delFile(String srcPackageDir, String classPackageDir, String fileName) {
        String src = String.valueOf(srcPackageDir) + fileName + ".java";
        this.deleteFile(src);
        String cls = String.valueOf(classPackageDir) + fileName + ".class";
        this.deleteFile(cls);
    }

    void deleteFile(String src) {
        File file = new File(src);
        if (file.exists()) {
            file.delete();
        }
    }

    List<String> getCompileOption() {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-encoding");
        options.add("UTF-8");
        options.add("-d");
        options.add(CLASS_DIR);
        if (StringUtils.isNotEmpty(this.classpath4compile)) {
            options.add("-classpath");
            options.add(this.classpath4compile);
        }
        return options;
    }

    private static String packageToPath(String packageName) {
        String sep = File.separator;
        return StringUtils.replace(packageName, ".", sep);
    }
}

