/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.common;

import com.greenpineyu.fel.common.ArrayUtils;
import com.greenpineyu.fel.common.Null;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectUtil {
    static final Map<Class<?>, Class<?>> wrapperCls;
    static final Map<Class<?>, Class<?>> primitiveCls;
    static final Map<Class<?>, Class<?>> numberClassMap;

    static {
        numberClassMap = ReflectUtil.wrapperNumberCls();
        primitiveCls = new HashMap(ReflectUtil.primitiveNumberCls());
        primitiveCls.put(Boolean.TYPE, Boolean.TYPE);
        primitiveCls.put(Boolean.class, Boolean.TYPE);
        wrapperCls = new HashMap(ReflectUtil.wrapperNumberCls());
        wrapperCls.put(Boolean.TYPE, Boolean.class);
        wrapperCls.put(Boolean.class, Boolean.class);
    }

    private static Map<Class<?>, Class<?>> primitiveNumberCls() {
        HashMap map = new HashMap();
        map.put(Byte.TYPE, Byte.TYPE);
        map.put(Byte.class, Byte.TYPE);
        map.put(Short.TYPE, Short.TYPE);
        map.put(Short.class, Short.TYPE);
        map.put(Integer.TYPE, Integer.TYPE);
        map.put(Integer.class, Integer.TYPE);
        map.put(Long.TYPE, Long.TYPE);
        map.put(Long.class, Long.TYPE);
        map.put(Float.TYPE, Float.TYPE);
        map.put(Float.class, Float.TYPE);
        map.put(Double.TYPE, Double.TYPE);
        map.put(Double.class, Double.TYPE);
        map.put(Character.TYPE, Character.TYPE);
        map.put(Character.class, Character.TYPE);
        return map;
    }

    private static Map<Class<?>, Class<?>> wrapperNumberCls() {
        HashMap map = new HashMap();
        map.put(Byte.TYPE, Byte.class);
        map.put(Byte.class, Byte.class);
        map.put(Short.TYPE, Short.class);
        map.put(Short.class, Short.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Integer.class, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Long.class, Long.class);
        map.put(Float.TYPE, Float.class);
        map.put(Float.class, Float.class);
        map.put(Double.TYPE, Double.class);
        map.put(Double.class, Double.class);
        map.put(Character.TYPE, Character.class);
        map.put(Character.class, Character.class);
        return map;
    }

    public static boolean isPrimitiveOrWrapNumber(Class<?> c) {
        return numberClassMap.containsKey(c);
    }

    public static boolean isPrimitiveNumber(Class<?> c) {
        if (c == null) {
            return false;
        }
        return c.isPrimitive() && c != Boolean.TYPE;
    }

    public static Class<?> toWrapperClass(Class<?> c) {
        return wrapperCls.get(c);
    }

    public static Class<?> toPrimitiveClass(Class<?> c) {
        return primitiveCls.get(c);
    }

    public static void sort(int[] array) {
        int i = 1;
        while (i < array.length) {
            int j = i - 1;
            int current = array[i];
            while (j > -1 && current < array[j]) {
                array[j + 1] = array[j];
                --j;
            }
            array[j + 1] = current;
            ++i;
        }
    }

    public static Method findMethod(Class<?> cls, String attr, Class<?>[] paramTypes) {
        String[] methodNames;
        if (attr == null || "".equals(attr)) {
            return null;
        }
        String firstUpper = String.valueOf(String.valueOf(attr.charAt(0)).toUpperCase()) + attr.substring(1);
        Method[] methods = cls.getMethods();
        Method finalMethod = null;
        String[] stringArray = methodNames = new String[]{attr, "get" + firstUpper, "is" + firstUpper};
        int n = methodNames.length;
        int n2 = 0;
        while (n2 < n) {
            String methodName = stringArray[n2];
            finalMethod = ReflectUtil.match(methodName, paramTypes, methods);
            if (finalMethod != null) break;
            ++n2;
        }
        return finalMethod;
    }

    public static Method getMethod(Class<?> cls, String methodName, Class<?>[] paramTypes) {
        Method[] methods = cls.getMethods();
        return ReflectUtil.match(methodName, paramTypes, methods);
    }

    private static Method match(String methodName, Class<?>[] paramValueTypes, Method[] methods) {
        Method finalMethod = null;
        Method nameParamLengthEqualsMethod = null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                Method m = methodArray[n2];
                String name = m.getName();
                if (name.equals(methodName)) {
                    Object[] methodParamTypes = m.getParameterTypes();
                    if (methodParamTypes != null && paramValueTypes != null) {
                        if (methodParamTypes.length == paramValueTypes.length) {
                            if (nameParamLengthEqualsMethod == null) {
                                nameParamLengthEqualsMethod = m;
                            }
                            int i = 0;
                            while (i < methodParamTypes.length) {
                                Object c1 = methodParamTypes[i];
                                Class<?> c2 = paramValueTypes[i];
                                if (ReflectUtil.isTypeMatch(c1, c2)) {
                                    ++i;
                                    continue;
                                }
                                break block9;
                            }
                            finalMethod = m;
                            break;
                        }
                    } else if (ArrayUtils.isEmpty(methodParamTypes) && ArrayUtils.isEmpty(paramValueTypes)) {
                        finalMethod = m;
                        break;
                    }
                }
            }
            ++n2;
        }
        return finalMethod == null ? nameParamLengthEqualsMethod : finalMethod;
    }

    public static boolean isTypeMatch(Class<?> c1, Class<?> c2) {
        if (c1 == c2 || c2 == Null.class) {
            return true;
        }
        Class<?> w1 = ReflectUtil.toWrapperClass(c1);
        Class<?> w2 = ReflectUtil.toWrapperClass(c2);
        if (w1 != null && w1 == w2) {
            return true;
        }
        return c1.isAssignableFrom(c2);
    }

    public static String getClassName(Class<?> cls) {
        if (cls == null) {
            return "null";
        }
        return cls.getCanonicalName();
    }
}

