/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.transaction.annotation;

import java.util.Collection;
import org.evosuite.shaded.org.springframework.beans.factory.annotation.Autowired;
import org.evosuite.shaded.org.springframework.context.annotation.Bean;
import org.evosuite.shaded.org.springframework.context.annotation.Configuration;
import org.evosuite.shaded.org.springframework.context.annotation.ImportAware;
import org.evosuite.shaded.org.springframework.context.annotation.Role;
import org.evosuite.shaded.org.springframework.core.annotation.AnnotationAttributes;
import org.evosuite.shaded.org.springframework.core.type.AnnotationMetadata;
import org.evosuite.shaded.org.springframework.transaction.PlatformTransactionManager;
import org.evosuite.shaded.org.springframework.transaction.annotation.EnableTransactionManagement;
import org.evosuite.shaded.org.springframework.transaction.annotation.TransactionManagementConfigurer;
import org.evosuite.shaded.org.springframework.transaction.event.TransactionalEventListenerFactory;
import org.evosuite.shaded.org.springframework.util.CollectionUtils;

@Configuration
public abstract class AbstractTransactionManagementConfiguration
implements ImportAware {
    protected AnnotationAttributes enableTx;
    protected PlatformTransactionManager txManager;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableTx = AnnotationAttributes.fromMap(importMetadata.getAnnotationAttributes(EnableTransactionManagement.class.getName(), false));
        if (this.enableTx == null) {
            throw new IllegalArgumentException("@EnableTransactionManagement is not present on importing class " + importMetadata.getClassName());
        }
    }

    @Autowired(required=false)
    void setConfigurers(Collection<TransactionManagementConfigurer> configurers) {
        if (CollectionUtils.isEmpty(configurers)) {
            return;
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException("Only one TransactionManagementConfigurer may exist");
        }
        TransactionManagementConfigurer configurer = configurers.iterator().next();
        this.txManager = configurer.annotationDrivenTransactionManager();
    }

    @Bean(name={"org.evosuite.shaded.org.springframework.transaction.config.internalTransactionalEventListenerFactory"})
    @Role(value=2)
    public TransactionalEventListenerFactory transactionalEventListenerFactory() {
        return new TransactionalEventListenerFactory();
    }
}

