/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.hibernate4;

import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.Session;
import org.evosuite.shaded.org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.evosuite.shaded.org.springframework.transaction.support.TransactionSynchronizationAdapter;

public class SpringFlushSynchronization
extends TransactionSynchronizationAdapter {
    private final Session session;

    public SpringFlushSynchronization(Session session) {
        this.session = session;
    }

    @Override
    public void flush() {
        try {
            SessionFactoryUtils.logger.debug("Flushing Hibernate Session on explicit request");
            this.session.flush();
        }
        catch (HibernateException ex) {
            throw SessionFactoryUtils.convertHibernateAccessException(ex);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof SpringFlushSynchronization && this.session == ((SpringFlushSynchronization)obj).session;
    }

    public int hashCode() {
        return this.session.hashCode();
    }
}

