/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.hibernate3;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.evosuite.shaded.org.hibernate.Criteria;
import org.evosuite.shaded.org.hibernate.Filter;
import org.evosuite.shaded.org.hibernate.FlushMode;
import org.evosuite.shaded.org.hibernate.Hibernate;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.LockMode;
import org.evosuite.shaded.org.hibernate.Query;
import org.evosuite.shaded.org.hibernate.ReplicationMode;
import org.evosuite.shaded.org.hibernate.Session;
import org.evosuite.shaded.org.hibernate.SessionFactory;
import org.evosuite.shaded.org.hibernate.criterion.DetachedCriteria;
import org.evosuite.shaded.org.hibernate.criterion.Example;
import org.evosuite.shaded.org.hibernate.engine.SessionImplementor;
import org.evosuite.shaded.org.hibernate.event.EventSource;
import org.evosuite.shaded.org.springframework.dao.DataAccessException;
import org.evosuite.shaded.org.springframework.dao.DataAccessResourceFailureException;
import org.evosuite.shaded.org.springframework.dao.InvalidDataAccessApiUsageException;
import org.evosuite.shaded.org.springframework.orm.hibernate3.HibernateAccessor;
import org.evosuite.shaded.org.springframework.orm.hibernate3.HibernateCallback;
import org.evosuite.shaded.org.springframework.orm.hibernate3.HibernateOperations;
import org.evosuite.shaded.org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.evosuite.shaded.org.springframework.util.Assert;

@Deprecated
public class HibernateTemplate
extends HibernateAccessor
implements HibernateOperations {
    private boolean allowCreate = true;
    private boolean alwaysUseNewSession = false;
    private boolean exposeNativeSession = false;
    private boolean checkWriteOperations = true;
    private boolean cacheQueries = false;
    private String queryCacheRegion;
    private int fetchSize = 0;
    private int maxResults = 0;

    public HibernateTemplate() {
    }

    public HibernateTemplate(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
        this.afterPropertiesSet();
    }

    public HibernateTemplate(SessionFactory sessionFactory, boolean allowCreate) {
        this.setSessionFactory(sessionFactory);
        this.setAllowCreate(allowCreate);
        this.afterPropertiesSet();
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void setAlwaysUseNewSession(boolean alwaysUseNewSession) {
        this.alwaysUseNewSession = alwaysUseNewSession;
    }

    public boolean isAlwaysUseNewSession() {
        return this.alwaysUseNewSession;
    }

    public void setExposeNativeSession(boolean exposeNativeSession) {
        this.exposeNativeSession = exposeNativeSession;
    }

    public boolean isExposeNativeSession() {
        return this.exposeNativeSession;
    }

    public void setCheckWriteOperations(boolean checkWriteOperations) {
        this.checkWriteOperations = checkWriteOperations;
    }

    public boolean isCheckWriteOperations() {
        return this.checkWriteOperations;
    }

    public void setCacheQueries(boolean cacheQueries) {
        this.cacheQueries = cacheQueries;
    }

    public boolean isCacheQueries() {
        return this.cacheQueries;
    }

    public void setQueryCacheRegion(String queryCacheRegion) {
        this.queryCacheRegion = queryCacheRegion;
    }

    public String getQueryCacheRegion() {
        return this.queryCacheRegion;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public <T> T execute(HibernateCallback<T> action) throws DataAccessException {
        return this.doExecute(action, false, false);
    }

    @Override
    @Deprecated
    public List<?> executeFind(HibernateCallback<?> action) throws DataAccessException {
        Object result = this.doExecute(action, false, false);
        if (result != null && !(result instanceof List)) {
            throw new InvalidDataAccessApiUsageException("Result object returned from HibernateCallback isn't a List: [" + result + "]");
        }
        return (List)result;
    }

    public <T> T executeWithNewSession(HibernateCallback<T> action) {
        return this.doExecute(action, true, false);
    }

    public <T> T executeWithNativeSession(HibernateCallback<T> action) {
        return this.doExecute(action, false, true);
    }

    protected <T> T doExecute(HibernateCallback<T> action, boolean enforceNewSession, boolean enforceNativeSession) throws DataAccessException {
        boolean existingTransaction;
        Assert.notNull(action, "Callback object must not be null");
        Session session = enforceNewSession ? SessionFactoryUtils.getNewSession(this.getSessionFactory(), this.getEntityInterceptor()) : this.getSession();
        boolean bl = existingTransaction = !enforceNewSession && (!this.isAllowCreate() || SessionFactoryUtils.isSessionTransactional(session, this.getSessionFactory()));
        if (existingTransaction) {
            this.logger.debug("Found thread-bound Session for HibernateTemplate");
        }
        FlushMode previousFlushMode = null;
        try {
            previousFlushMode = this.applyFlushMode(session, existingTransaction);
            this.enableFilters(session);
            Session sessionToExpose = enforceNativeSession || this.isExposeNativeSession() ? session : this.createSessionProxy(session);
            T result = action.doInHibernate(sessionToExpose);
            this.flushIfNecessary(session, existingTransaction);
            T t = result;
            return t;
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        catch (SQLException ex) {
            throw this.convertJdbcAccessException(ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            if (existingTransaction) {
                this.logger.debug("Not closing pre-bound Hibernate Session after HibernateTemplate");
                this.disableFilters(session);
                if (previousFlushMode != null) {
                    session.setFlushMode(previousFlushMode);
                }
            } else if (this.isAlwaysUseNewSession()) {
                SessionFactoryUtils.closeSession(session);
            } else {
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.getSessionFactory());
            }
        }
    }

    protected Session getSession() {
        if (this.isAlwaysUseNewSession()) {
            return SessionFactoryUtils.getNewSession(this.getSessionFactory(), this.getEntityInterceptor());
        }
        if (this.isAllowCreate()) {
            return SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
        }
        if (SessionFactoryUtils.hasTransactionalSession(this.getSessionFactory())) {
            return SessionFactoryUtils.getSession(this.getSessionFactory(), false);
        }
        try {
            return this.getSessionFactory().getCurrentSession();
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not obtain current Hibernate Session", ex);
        }
    }

    protected Session createSessionProxy(Session session) {
        Class mainIfc;
        Class clazz = mainIfc = session instanceof org.evosuite.shaded.org.hibernate.classic.Session ? org.evosuite.shaded.org.hibernate.classic.Session.class : Session.class;
        Class[] sessionIfcs = session instanceof EventSource ? new Class[]{mainIfc, EventSource.class} : (session instanceof SessionImplementor ? new Class[]{mainIfc, SessionImplementor.class} : new Class[]{mainIfc});
        return (Session)Proxy.newProxyInstance(session.getClass().getClassLoader(), sessionIfcs, (InvocationHandler)new CloseSuppressingInvocationHandler(session));
    }

    @Override
    public <T> T get(Class<T> entityClass, Serializable id) throws DataAccessException {
        return this.get(entityClass, id, null);
    }

    @Override
    public <T> T get(final Class<T> entityClass, final Serializable id, final LockMode lockMode) throws DataAccessException {
        return this.executeWithNativeSession(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    return session.get(entityClass, id, lockMode);
                }
                return session.get(entityClass, id);
            }
        });
    }

    @Override
    public Object get(String entityName, Serializable id) throws DataAccessException {
        return this.get(entityName, id, null);
    }

    @Override
    public Object get(final String entityName, final Serializable id, final LockMode lockMode) throws DataAccessException {
        return this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    return session.get(entityName, id, lockMode);
                }
                return session.get(entityName, id);
            }
        });
    }

    @Override
    public <T> T load(Class<T> entityClass, Serializable id) throws DataAccessException {
        return this.load(entityClass, id, null);
    }

    @Override
    public <T> T load(final Class<T> entityClass, final Serializable id, final LockMode lockMode) throws DataAccessException {
        return this.executeWithNativeSession(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    return session.load(entityClass, id, lockMode);
                }
                return session.load(entityClass, id);
            }
        });
    }

    @Override
    public Object load(String entityName, Serializable id) throws DataAccessException {
        return this.load(entityName, id, null);
    }

    @Override
    public Object load(final String entityName, final Serializable id, final LockMode lockMode) throws DataAccessException {
        return this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    return session.load(entityName, id, lockMode);
                }
                return session.load(entityName, id);
            }
        });
    }

    @Override
    public <T> List<T> loadAll(final Class<T> entityClass) throws DataAccessException {
        return (List)this.executeWithNativeSession(new HibernateCallback<List<T>>(){

            @Override
            public List<T> doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(entityClass);
                criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
                HibernateTemplate.this.prepareCriteria(criteria);
                return criteria.list();
            }
        });
    }

    @Override
    public void load(final Object entity, final Serializable id) throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                session.load(entity, id);
                return null;
            }
        });
    }

    @Override
    public void refresh(Object entity) throws DataAccessException {
        this.refresh(entity, null);
    }

    @Override
    public void refresh(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    session.refresh(entity, lockMode);
                } else {
                    session.refresh(entity);
                }
                return null;
            }
        });
    }

    @Override
    public boolean contains(final Object entity) throws DataAccessException {
        return this.executeWithNativeSession(new HibernateCallback<Boolean>(){

            @Override
            public Boolean doInHibernate(Session session) {
                return session.contains(entity);
            }
        });
    }

    @Override
    public void evict(final Object entity) throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                session.evict(entity);
                return null;
            }
        });
    }

    @Override
    public void initialize(Object proxy) throws DataAccessException {
        try {
            Hibernate.initialize(proxy);
        }
        catch (HibernateException ex) {
            throw SessionFactoryUtils.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Filter enableFilter(String filterName) throws IllegalStateException {
        Session session = SessionFactoryUtils.getSession(this.getSessionFactory(), false);
        Filter filter = session.getEnabledFilter(filterName);
        if (filter == null) {
            filter = session.enableFilter(filterName);
        }
        return filter;
    }

    @Override
    public void lock(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                session.lock(entity, lockMode);
                return null;
            }
        });
    }

    @Override
    public void lock(final String entityName, final Object entity, final LockMode lockMode) throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                session.lock(entityName, entity, lockMode);
                return null;
            }
        });
    }

    @Override
    public Serializable save(final Object entity) throws DataAccessException {
        return this.executeWithNativeSession(new HibernateCallback<Serializable>(){

            @Override
            public Serializable doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return session.save(entity);
            }
        });
    }

    @Override
    public Serializable save(final String entityName, final Object entity) throws DataAccessException {
        return this.executeWithNativeSession(new HibernateCallback<Serializable>(){

            @Override
            public Serializable doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return session.save(entityName, entity);
            }
        });
    }

    @Override
    public void update(Object entity) throws DataAccessException {
        this.update(entity, null);
    }

    @Override
    public void update(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.update(entity);
                if (lockMode != null) {
                    session.lock(entity, lockMode);
                }
                return null;
            }
        });
    }

    @Override
    public void update(String entityName, Object entity) throws DataAccessException {
        this.update(entityName, entity, null);
    }

    @Override
    public void update(final String entityName, final Object entity, final LockMode lockMode) throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.update(entityName, entity);
                if (lockMode != null) {
                    session.lock(entity, lockMode);
                }
                return null;
            }
        });
    }

    @Override
    public void saveOrUpdate(final Object entity) throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.saveOrUpdate(entity);
                return null;
            }
        });
    }

    @Override
    public void saveOrUpdate(final String entityName, final Object entity) throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.saveOrUpdate(entityName, entity);
                return null;
            }
        });
    }

    @Override
    public void replicate(final Object entity, final ReplicationMode replicationMode) throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.replicate(entity, replicationMode);
                return null;
            }
        });
    }

    @Override
    public void replicate(final String entityName, final Object entity, final ReplicationMode replicationMode) throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.replicate(entityName, entity, replicationMode);
                return null;
            }
        });
    }

    @Override
    public void persist(final Object entity) throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.persist(entity);
                return null;
            }
        });
    }

    @Override
    public void persist(final String entityName, final Object entity) throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.persist(entityName, entity);
                return null;
            }
        });
    }

    @Override
    public <T> T merge(final T entity) throws DataAccessException {
        return this.executeWithNativeSession(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return session.merge(entity);
            }
        });
    }

    @Override
    public <T> T merge(final String entityName, final T entity) throws DataAccessException {
        return this.executeWithNativeSession(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return session.merge(entityName, entity);
            }
        });
    }

    @Override
    public void delete(Object entity) throws DataAccessException {
        this.delete(entity, null);
    }

    @Override
    public void delete(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                if (lockMode != null) {
                    session.lock(entity, lockMode);
                }
                session.delete(entity);
                return null;
            }
        });
    }

    @Override
    public void delete(String entityName, Object entity) throws DataAccessException {
        this.delete(entityName, entity, null);
    }

    @Override
    public void delete(final String entityName, final Object entity, final LockMode lockMode) throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                if (lockMode != null) {
                    session.lock(entityName, entity, lockMode);
                }
                session.delete(entityName, entity);
                return null;
            }
        });
    }

    @Override
    public void deleteAll(final Collection<?> entities) throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                for (Object entity : entities) {
                    session.delete(entity);
                }
                return null;
            }
        });
    }

    @Override
    public void flush() throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                session.flush();
                return null;
            }
        });
    }

    @Override
    public void clear() throws DataAccessException {
        this.executeWithNativeSession(new HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) {
                session.clear();
                return null;
            }
        });
    }

    @Override
    public List<?> find(String queryString) throws DataAccessException {
        return this.find(queryString, (Object[])null);
    }

    @Override
    public List<?> find(String queryString, Object value) throws DataAccessException {
        return this.find(queryString, new Object[]{value});
    }

    @Override
    public List<?> find(final String queryString, final Object ... values) throws DataAccessException {
        return (List)this.executeWithNativeSession(new HibernateCallback<List<?>>(){

            @Override
            public List<?> doInHibernate(Session session) throws HibernateException {
                javax.persistence.Query queryObject = session.createQuery(queryString);
                HibernateTemplate.this.prepareQuery((Query)queryObject);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        queryObject.setParameter(i, values[i]);
                    }
                }
                return queryObject.list();
            }
        });
    }

    @Override
    public List<?> findByNamedParam(String queryString, String paramName, Object value) throws DataAccessException {
        return this.findByNamedParam(queryString, new String[]{paramName}, new Object[]{value});
    }

    @Override
    public List<?> findByNamedParam(final String queryString, final String[] paramNames, final Object[] values) throws DataAccessException {
        if (paramNames.length != values.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of values array");
        }
        return (List)this.executeWithNativeSession(new HibernateCallback<List<?>>(){

            @Override
            public List<?> doInHibernate(Session session) throws HibernateException {
                javax.persistence.Query queryObject = session.createQuery(queryString);
                HibernateTemplate.this.prepareQuery((Query)queryObject);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        HibernateTemplate.this.applyNamedParameterToQuery((Query)queryObject, paramNames[i], values[i]);
                    }
                }
                return queryObject.list();
            }
        });
    }

    @Override
    public List<?> findByValueBean(final String queryString, final Object valueBean) throws DataAccessException {
        return (List)this.executeWithNativeSession(new HibernateCallback<List<?>>(){

            @Override
            public List<?> doInHibernate(Session session) throws HibernateException {
                javax.persistence.Query queryObject = session.createQuery(queryString);
                HibernateTemplate.this.prepareQuery((Query)queryObject);
                queryObject.setProperties(valueBean);
                return queryObject.list();
            }
        });
    }

    @Override
    public List<?> findByNamedQuery(String queryName) throws DataAccessException {
        return this.findByNamedQuery(queryName, (Object[])null);
    }

    @Override
    public List<?> findByNamedQuery(String queryName, Object value) throws DataAccessException {
        return this.findByNamedQuery(queryName, new Object[]{value});
    }

    @Override
    public List<?> findByNamedQuery(final String queryName, final Object ... values) throws DataAccessException {
        return (List)this.executeWithNativeSession(new HibernateCallback<List<?>>(){

            @Override
            public List<?> doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                HibernateTemplate.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        queryObject.setParameter(i, values[i]);
                    }
                }
                return queryObject.list();
            }
        });
    }

    @Override
    public List<?> findByNamedQueryAndNamedParam(String queryName, String paramName, Object value) throws DataAccessException {
        return this.findByNamedQueryAndNamedParam(queryName, new String[]{paramName}, new Object[]{value});
    }

    @Override
    public List<?> findByNamedQueryAndNamedParam(final String queryName, final String[] paramNames, final Object[] values) throws DataAccessException {
        if (values != null && (paramNames == null || paramNames.length != values.length)) {
            throw new IllegalArgumentException("Length of paramNames array must match length of values array");
        }
        return (List)this.executeWithNativeSession(new HibernateCallback<List<?>>(){

            @Override
            public List<?> doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                HibernateTemplate.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        HibernateTemplate.this.applyNamedParameterToQuery(queryObject, paramNames[i], values[i]);
                    }
                }
                return queryObject.list();
            }
        });
    }

    @Override
    public List<?> findByNamedQueryAndValueBean(final String queryName, final Object valueBean) throws DataAccessException {
        return (List)this.executeWithNativeSession(new HibernateCallback<List<?>>(){

            @Override
            public List<?> doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                HibernateTemplate.this.prepareQuery(queryObject);
                queryObject.setProperties(valueBean);
                return queryObject.list();
            }
        });
    }

    @Override
    public List<?> findByCriteria(DetachedCriteria criteria) throws DataAccessException {
        return this.findByCriteria(criteria, -1, -1);
    }

    @Override
    public List<?> findByCriteria(final DetachedCriteria criteria, final int firstResult, final int maxResults) throws DataAccessException {
        Assert.notNull(criteria, "DetachedCriteria must not be null");
        return (List)this.executeWithNativeSession(new HibernateCallback<List<?>>(){

            @Override
            public List<?> doInHibernate(Session session) throws HibernateException {
                Criteria executableCriteria = criteria.getExecutableCriteria(session);
                HibernateTemplate.this.prepareCriteria(executableCriteria);
                if (firstResult >= 0) {
                    executableCriteria.setFirstResult(firstResult);
                }
                if (maxResults > 0) {
                    executableCriteria.setMaxResults(maxResults);
                }
                return executableCriteria.list();
            }
        });
    }

    @Override
    public <T> List<T> findByExample(T exampleEntity) throws DataAccessException {
        return this.findByExample(null, exampleEntity, -1, -1);
    }

    @Override
    public <T> List<T> findByExample(String entityName, T exampleEntity) throws DataAccessException {
        return this.findByExample(entityName, exampleEntity, -1, -1);
    }

    @Override
    public <T> List<T> findByExample(T exampleEntity, int firstResult, int maxResults) throws DataAccessException {
        return this.findByExample(null, exampleEntity, firstResult, maxResults);
    }

    @Override
    public <T> List<T> findByExample(final String entityName, final T exampleEntity, final int firstResult, final int maxResults) throws DataAccessException {
        Assert.notNull(exampleEntity, "Example entity must not be null");
        return (List)this.executeWithNativeSession(new HibernateCallback<List<T>>(){

            @Override
            public List<T> doInHibernate(Session session) throws HibernateException {
                Criteria executableCriteria = entityName != null ? session.createCriteria(entityName) : session.createCriteria(exampleEntity.getClass());
                executableCriteria.add(Example.create(exampleEntity));
                HibernateTemplate.this.prepareCriteria(executableCriteria);
                if (firstResult >= 0) {
                    executableCriteria.setFirstResult(firstResult);
                }
                if (maxResults > 0) {
                    executableCriteria.setMaxResults(maxResults);
                }
                return executableCriteria.list();
            }
        });
    }

    @Override
    public Iterator<?> iterate(String queryString) throws DataAccessException {
        return this.iterate(queryString, (Object[])null);
    }

    @Override
    public Iterator<?> iterate(String queryString, Object value) throws DataAccessException {
        return this.iterate(queryString, new Object[]{value});
    }

    @Override
    public Iterator<?> iterate(final String queryString, final Object ... values) throws DataAccessException {
        return (Iterator)this.executeWithNativeSession(new HibernateCallback<Iterator<?>>(){

            @Override
            public Iterator<?> doInHibernate(Session session) throws HibernateException {
                javax.persistence.Query queryObject = session.createQuery(queryString);
                HibernateTemplate.this.prepareQuery((Query)queryObject);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        queryObject.setParameter(i, values[i]);
                    }
                }
                return queryObject.iterate();
            }
        });
    }

    @Override
    public void closeIterator(Iterator<?> it) throws DataAccessException {
        try {
            Hibernate.close(it);
        }
        catch (HibernateException ex) {
            throw SessionFactoryUtils.convertHibernateAccessException(ex);
        }
    }

    @Override
    public int bulkUpdate(String queryString) throws DataAccessException {
        return this.bulkUpdate(queryString, (Object[])null);
    }

    @Override
    public int bulkUpdate(String queryString, Object value) throws DataAccessException {
        return this.bulkUpdate(queryString, new Object[]{value});
    }

    @Override
    public int bulkUpdate(final String queryString, final Object ... values) throws DataAccessException {
        return this.executeWithNativeSession(new HibernateCallback<Integer>(){

            @Override
            public Integer doInHibernate(Session session) throws HibernateException {
                javax.persistence.Query queryObject = session.createQuery(queryString);
                HibernateTemplate.this.prepareQuery((Query)queryObject);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        queryObject.setParameter(i, values[i]);
                    }
                }
                return queryObject.executeUpdate();
            }
        });
    }

    protected void checkWriteOperationAllowed(Session session) throws InvalidDataAccessApiUsageException {
        if (this.isCheckWriteOperations() && this.getFlushMode() != 2 && session.getFlushMode().lessThan(FlushMode.COMMIT)) {
            throw new InvalidDataAccessApiUsageException("Write operations are not allowed in read-only mode (FlushMode.MANUAL): Turn your Session into FlushMode.COMMIT/AUTO or remove 'readOnly' marker from transaction definition.");
        }
    }

    protected void prepareQuery(Query queryObject) {
        if (this.isCacheQueries()) {
            queryObject.setCacheable(true);
            if (this.getQueryCacheRegion() != null) {
                queryObject.setCacheRegion(this.getQueryCacheRegion());
            }
        }
        if (this.getFetchSize() > 0) {
            queryObject.setFetchSize(this.getFetchSize());
        }
        if (this.getMaxResults() > 0) {
            queryObject.setMaxResults(this.getMaxResults());
        }
        SessionFactoryUtils.applyTransactionTimeout(queryObject, this.getSessionFactory());
    }

    protected void prepareCriteria(Criteria criteria) {
        if (this.isCacheQueries()) {
            criteria.setCacheable(true);
            if (this.getQueryCacheRegion() != null) {
                criteria.setCacheRegion(this.getQueryCacheRegion());
            }
        }
        if (this.getFetchSize() > 0) {
            criteria.setFetchSize(this.getFetchSize());
        }
        if (this.getMaxResults() > 0) {
            criteria.setMaxResults(this.getMaxResults());
        }
        SessionFactoryUtils.applyTransactionTimeout(criteria, this.getSessionFactory());
    }

    protected void applyNamedParameterToQuery(Query queryObject, String paramName, Object value) throws HibernateException {
        if (value instanceof Collection) {
            queryObject.setParameterList(paramName, (Collection)value);
        } else if (value instanceof Object[]) {
            queryObject.setParameterList(paramName, (Object[])value);
        } else {
            queryObject.setParameter(paramName, value);
        }
    }

    private class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Session target;

        public CloseSuppressingInvocationHandler(Session target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                if (retVal instanceof Query) {
                    HibernateTemplate.this.prepareQuery((Query)retVal);
                }
                if (retVal instanceof Criteria) {
                    HibernateTemplate.this.prepareCriteria((Criteria)retVal);
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

