/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.object;

import org.evosuite.shaded.org.springframework.jdbc.core.PreparedStatementCreator;
import org.evosuite.shaded.org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.evosuite.shaded.org.springframework.jdbc.core.PreparedStatementSetter;
import org.evosuite.shaded.org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.evosuite.shaded.org.springframework.jdbc.core.namedparam.ParsedSql;
import org.evosuite.shaded.org.springframework.jdbc.object.RdbmsOperation;

public abstract class SqlOperation
extends RdbmsOperation {
    private PreparedStatementCreatorFactory preparedStatementFactory;
    private ParsedSql cachedSql;
    private final Object parsedSqlMonitor = new Object();

    @Override
    protected final void compileInternal() {
        this.preparedStatementFactory = new PreparedStatementCreatorFactory(this.getSql(), this.getDeclaredParameters());
        this.preparedStatementFactory.setResultSetType(this.getResultSetType());
        this.preparedStatementFactory.setUpdatableResults(this.isUpdatableResults());
        this.preparedStatementFactory.setReturnGeneratedKeys(this.isReturnGeneratedKeys());
        if (this.getGeneratedKeysColumnNames() != null) {
            this.preparedStatementFactory.setGeneratedKeysColumnNames(this.getGeneratedKeysColumnNames());
        }
        this.preparedStatementFactory.setNativeJdbcExtractor(this.getJdbcTemplate().getNativeJdbcExtractor());
        this.onCompileInternal();
    }

    protected void onCompileInternal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParsedSql getParsedSql() {
        Object object = this.parsedSqlMonitor;
        synchronized (object) {
            if (this.cachedSql == null) {
                this.cachedSql = NamedParameterUtils.parseSqlStatement(this.getSql());
            }
            return this.cachedSql;
        }
    }

    protected final PreparedStatementSetter newPreparedStatementSetter(Object[] params) {
        return this.preparedStatementFactory.newPreparedStatementSetter(params);
    }

    protected final PreparedStatementCreator newPreparedStatementCreator(Object[] params) {
        return this.preparedStatementFactory.newPreparedStatementCreator(params);
    }

    protected final PreparedStatementCreator newPreparedStatementCreator(String sqlToUse, Object[] params) {
        return this.preparedStatementFactory.newPreparedStatementCreator(sqlToUse, params);
    }
}

