/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.core.metadata;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.evosuite.shaded.org.springframework.jdbc.core.ColumnMapRowMapper;
import org.evosuite.shaded.org.springframework.jdbc.core.SqlOutParameter;
import org.evosuite.shaded.org.springframework.jdbc.core.SqlParameter;
import org.evosuite.shaded.org.springframework.jdbc.core.metadata.CallParameterMetaData;
import org.evosuite.shaded.org.springframework.jdbc.core.metadata.GenericCallMetaDataProvider;

public class PostgresCallMetaDataProvider
extends GenericCallMetaDataProvider {
    private static final String RETURN_VALUE_NAME = "returnValue";

    public PostgresCallMetaDataProvider(DatabaseMetaData databaseMetaData) throws SQLException {
        super(databaseMetaData);
    }

    @Override
    public boolean isReturnResultSetSupported() {
        return false;
    }

    @Override
    public boolean isRefCursorSupported() {
        return true;
    }

    @Override
    public int getRefCursorSqlType() {
        return 1111;
    }

    @Override
    public String metaDataSchemaNameToUse(String schemaName) {
        return schemaName == null ? "public" : super.metaDataSchemaNameToUse(schemaName);
    }

    @Override
    public SqlParameter createDefaultOutParameter(String parameterName, CallParameterMetaData meta) {
        if (meta.getSqlType() == 1111 && "refcursor".equals(meta.getTypeName())) {
            return new SqlOutParameter(parameterName, this.getRefCursorSqlType(), new ColumnMapRowMapper());
        }
        return super.createDefaultOutParameter(parameterName, meta);
    }

    @Override
    public boolean byPassReturnParameter(String parameterName) {
        return RETURN_VALUE_NAME.equals(parameterName);
    }
}

