/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.config;

import org.evosuite.shaded.org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.evosuite.shaded.org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.evosuite.shaded.org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.evosuite.shaded.org.springframework.beans.factory.xml.ParserContext;
import org.evosuite.shaded.org.springframework.jdbc.config.DatabasePopulatorConfigUtils;
import org.evosuite.shaded.org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseFactoryBean;
import org.evosuite.shaded.org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class EmbeddedDatabaseBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    static final String DB_NAME_ATTRIBUTE = "database-name";
    static final String GENERATE_NAME_ATTRIBUTE = "generate-name";

    EmbeddedDatabaseBeanDefinitionParser() {
    }

    @Override
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(EmbeddedDatabaseFactoryBean.class);
        this.setGenerateUniqueDatabaseNameFlag(element, builder);
        this.setDatabaseName(element, builder);
        this.setDatabaseType(element, builder);
        DatabasePopulatorConfigUtils.setDatabasePopulator(element, builder);
        builder.getRawBeanDefinition().setSource(parserContext.extractSource(element));
        return builder.getBeanDefinition();
    }

    @Override
    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    private void setGenerateUniqueDatabaseNameFlag(Element element, BeanDefinitionBuilder builder) {
        String generateName = element.getAttribute(GENERATE_NAME_ATTRIBUTE);
        if (StringUtils.hasText(generateName)) {
            builder.addPropertyValue("generateUniqueDatabaseName", generateName);
        }
    }

    private void setDatabaseName(Element element, BeanDefinitionBuilder builder) {
        String name = element.getAttribute(DB_NAME_ATTRIBUTE);
        if (!StringUtils.hasText(name)) {
            name = element.getAttribute("id");
        }
        if (StringUtils.hasText(name)) {
            builder.addPropertyValue("databaseName", name);
        }
    }

    private void setDatabaseType(Element element, BeanDefinitionBuilder builder) {
        String type = element.getAttribute("type");
        if (StringUtils.hasText(type)) {
            builder.addPropertyValue("databaseType", type);
        }
    }
}

