/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.instrument.classloading;

import java.lang.instrument.ClassFileTransformer;
import org.evosuite.shaded.org.springframework.instrument.classloading.LoadTimeWeaver;
import org.evosuite.shaded.org.springframework.instrument.classloading.SimpleInstrumentableClassLoader;
import org.evosuite.shaded.org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.evosuite.shaded.org.springframework.util.Assert;
import org.evosuite.shaded.org.springframework.util.ClassUtils;

public class SimpleLoadTimeWeaver
implements LoadTimeWeaver {
    private final SimpleInstrumentableClassLoader classLoader;

    public SimpleLoadTimeWeaver() {
        this.classLoader = new SimpleInstrumentableClassLoader(ClassUtils.getDefaultClassLoader());
    }

    public SimpleLoadTimeWeaver(SimpleInstrumentableClassLoader classLoader) {
        Assert.notNull(classLoader, "ClassLoader must not be null");
        this.classLoader = classLoader;
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        this.classLoader.addTransformer(transformer);
    }

    @Override
    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader;
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        return new SimpleThrowawayClassLoader(this.getInstrumentableClassLoader());
    }
}

