/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.cache.interceptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.evosuite.shaded.org.springframework.beans.factory.InitializingBean;
import org.evosuite.shaded.org.springframework.cache.Cache;
import org.evosuite.shaded.org.springframework.cache.CacheManager;
import org.evosuite.shaded.org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.evosuite.shaded.org.springframework.cache.interceptor.CacheResolver;
import org.evosuite.shaded.org.springframework.util.Assert;

public abstract class AbstractCacheResolver
implements CacheResolver,
InitializingBean {
    private CacheManager cacheManager;

    protected AbstractCacheResolver() {
    }

    protected AbstractCacheResolver(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.notNull(this.cacheManager, "CacheManager is required");
    }

    @Override
    public Collection<? extends Cache> resolveCaches(CacheOperationInvocationContext<?> context) {
        Collection<String> cacheNames = this.getCacheNames(context);
        if (cacheNames == null) {
            return Collections.emptyList();
        }
        ArrayList<Cache> result = new ArrayList<Cache>();
        for (String cacheName : cacheNames) {
            Cache cache = this.getCacheManager().getCache(cacheName);
            if (cache == null) {
                throw new IllegalArgumentException("Cannot find cache named '" + cacheName + "' for " + context.getOperation());
            }
            result.add(cache);
        }
        return result;
    }

    protected abstract Collection<String> getCacheNames(CacheOperationInvocationContext<?> var1);
}

