/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.beans.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import org.evosuite.shaded.org.springframework.beans.BeanWrapper;
import org.evosuite.shaded.org.springframework.beans.PropertyAccessorFactory;
import org.evosuite.shaded.org.springframework.util.ReflectionUtils;
import org.evosuite.shaded.org.springframework.util.StringValueResolver;

public abstract class AnnotationBeanUtils {
    public static void copyPropertiesToBean(Annotation ann, Object bean, String ... excludedProperties) {
        AnnotationBeanUtils.copyPropertiesToBean(ann, bean, null, excludedProperties);
    }

    public static void copyPropertiesToBean(Annotation ann, Object bean, StringValueResolver valueResolver, String ... excludedProperties) {
        HashSet<String> excluded = new HashSet<String>(Arrays.asList(excludedProperties));
        Method[] annotationProperties = ann.annotationType().getDeclaredMethods();
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess(bean);
        for (Method annotationProperty : annotationProperties) {
            String propertyName = annotationProperty.getName();
            if (excluded.contains(propertyName) || !bw.isWritableProperty(propertyName)) continue;
            Object value = ReflectionUtils.invokeMethod(annotationProperty, ann);
            if (valueResolver != null && value instanceof String) {
                value = valueResolver.resolveStringValue((String)value);
            }
            bw.setPropertyValue(propertyName, value);
        }
    }
}

