/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.verification;

import org.evosuite.shaded.org.mockito.exceptions.base.MockitoException;
import org.evosuite.shaded.org.mockito.internal.verification.VerificationModeFactory;
import org.evosuite.shaded.org.mockito.internal.verification.api.VerificationData;
import org.evosuite.shaded.org.mockito.internal.verification.api.VerificationDataInOrder;
import org.evosuite.shaded.org.mockito.internal.verification.api.VerificationInOrderMode;
import org.evosuite.shaded.org.mockito.internal.verification.checkers.AtLeastXNumberOfInvocationsChecker;
import org.evosuite.shaded.org.mockito.internal.verification.checkers.MissingInvocationChecker;
import org.evosuite.shaded.org.mockito.verification.VerificationMode;

public class AtLeast
implements VerificationInOrderMode,
VerificationMode {
    final int wantedCount;

    public AtLeast(int wantedNumberOfInvocations) {
        if (wantedNumberOfInvocations < 0) {
            throw new MockitoException("Negative value is not allowed here");
        }
        this.wantedCount = wantedNumberOfInvocations;
    }

    @Override
    public void verify(VerificationData data) {
        if (this.wantedCount == 1) {
            MissingInvocationChecker.checkMissingInvocation(data.getAllInvocations(), data.getTarget());
        }
        AtLeastXNumberOfInvocationsChecker.checkAtLeastNumberOfInvocations(data.getAllInvocations(), data.getTarget(), this.wantedCount);
    }

    @Override
    public void verifyInOrder(VerificationDataInOrder data) {
        if (this.wantedCount == 1) {
            MissingInvocationChecker.checkMissingInvocation(data.getAllInvocations(), data.getWanted(), data.getOrderingContext());
        }
        AtLeastXNumberOfInvocationsChecker.checkAtLeastNumberOfInvocations(data.getAllInvocations(), data.getWanted(), this.wantedCount, data.getOrderingContext());
    }

    public String toString() {
        return "Wanted invocations count: at least " + this.wantedCount;
    }

    @Override
    public VerificationMode description(String description) {
        return VerificationModeFactory.description(this, description);
    }
}

