/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.runners;

import org.evosuite.shaded.org.mockito.Mockito;
import org.evosuite.shaded.org.mockito.internal.junit.UnnecessaryStubbingsReporter;
import org.evosuite.shaded.org.mockito.internal.runners.InternalRunner;
import org.evosuite.shaded.org.mockito.internal.runners.util.FailureDetector;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

public class StrictRunner
implements InternalRunner {
    private final Class<?> testClass;
    private final InternalRunner runner;
    private boolean filterRequested;

    public StrictRunner(InternalRunner runner, Class<?> testClass) {
        this.runner = runner;
        this.testClass = testClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(RunNotifier notifier) {
        UnnecessaryStubbingsReporter reporter = new UnnecessaryStubbingsReporter();
        FailureDetector listener = new FailureDetector();
        Mockito.framework().addListener(reporter);
        try {
            notifier.addListener((RunListener)listener);
            this.runner.run(notifier);
        }
        finally {
            Mockito.framework().removeListener(reporter);
        }
        if (!this.filterRequested && listener.isSuccessful()) {
            reporter.validateUnusedStubs(this.testClass, notifier);
        }
    }

    @Override
    public Description getDescription() {
        return this.runner.getDescription();
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        this.filterRequested = true;
        this.runner.filter(filter);
    }
}

