/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.handler;

import java.util.List;
import org.evosuite.shaded.org.mockito.internal.creation.settings.CreationSettings;
import org.evosuite.shaded.org.mockito.internal.exceptions.Reporter;
import org.evosuite.shaded.org.mockito.internal.invocation.InvocationMatcher;
import org.evosuite.shaded.org.mockito.internal.invocation.MatchersBinder;
import org.evosuite.shaded.org.mockito.internal.listeners.StubbingLookupListener;
import org.evosuite.shaded.org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.evosuite.shaded.org.mockito.internal.stubbing.InvocationContainerImpl;
import org.evosuite.shaded.org.mockito.internal.stubbing.OngoingStubbingImpl;
import org.evosuite.shaded.org.mockito.internal.stubbing.StubbedInvocationMatcher;
import org.evosuite.shaded.org.mockito.internal.stubbing.answers.DefaultAnswerValidator;
import org.evosuite.shaded.org.mockito.internal.verification.MockAwareVerificationMode;
import org.evosuite.shaded.org.mockito.internal.verification.VerificationDataImpl;
import org.evosuite.shaded.org.mockito.invocation.Invocation;
import org.evosuite.shaded.org.mockito.invocation.InvocationContainer;
import org.evosuite.shaded.org.mockito.invocation.MockHandler;
import org.evosuite.shaded.org.mockito.mock.MockCreationSettings;
import org.evosuite.shaded.org.mockito.verification.VerificationMode;

public class MockHandlerImpl<T>
implements MockHandler<T> {
    private static final long serialVersionUID = -2917871070982574165L;
    InvocationContainerImpl invocationContainer;
    MatchersBinder matchersBinder = new MatchersBinder();
    private final MockCreationSettings<T> mockSettings;

    public MockHandlerImpl(MockCreationSettings<T> mockSettings) {
        this.mockSettings = mockSettings;
        this.matchersBinder = new MatchersBinder();
        this.invocationContainer = new InvocationContainerImpl(mockSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object handle(Invocation invocation) throws Throwable {
        if (this.invocationContainer.hasAnswersForStubbing()) {
            InvocationMatcher invocationMatcher = this.matchersBinder.bindMatchers(ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage(), invocation);
            this.invocationContainer.setMethodForStubbing(invocationMatcher);
            return null;
        }
        VerificationMode verificationMode = ThreadSafeMockingProgress.mockingProgress().pullVerificationMode();
        InvocationMatcher invocationMatcher = this.matchersBinder.bindMatchers(ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage(), invocation);
        ThreadSafeMockingProgress.mockingProgress().validateState();
        if (verificationMode != null) {
            if (((MockAwareVerificationMode)verificationMode).getMock() == invocation.getMock()) {
                VerificationDataImpl data = this.createVerificationData(this.invocationContainer, invocationMatcher);
                verificationMode.verify(data);
                return null;
            }
            ThreadSafeMockingProgress.mockingProgress().verificationStarted(verificationMode);
        }
        this.invocationContainer.setInvocationForPotentialStubbing(invocationMatcher);
        OngoingStubbingImpl ongoingStubbing = new OngoingStubbingImpl(this.invocationContainer);
        ThreadSafeMockingProgress.mockingProgress().reportOngoingStubbing(ongoingStubbing);
        StubbedInvocationMatcher stubbing = this.invocationContainer.findAnswerFor(invocation);
        this.notifyStubbedAnswerLookup(invocation, stubbing);
        if (stubbing != null) {
            stubbing.captureArgumentsFrom(invocation);
            try {
                Object object = stubbing.answer(invocation);
                return object;
            }
            finally {
                ThreadSafeMockingProgress.mockingProgress().reportOngoingStubbing(ongoingStubbing);
            }
        }
        Object ret = this.mockSettings.getDefaultAnswer().answer(invocation);
        DefaultAnswerValidator.validateReturnValueFor(invocation, ret);
        this.invocationContainer.resetInvocationForPotentialStubbing(invocationMatcher);
        return ret;
    }

    @Override
    public MockCreationSettings<T> getMockSettings() {
        return this.mockSettings;
    }

    @Override
    public InvocationContainer getInvocationContainer() {
        return this.invocationContainer;
    }

    private VerificationDataImpl createVerificationData(InvocationContainerImpl invocationContainer, InvocationMatcher invocationMatcher) {
        if (this.mockSettings.isStubOnly()) {
            throw Reporter.stubPassedToVerify();
        }
        return new VerificationDataImpl(invocationContainer, invocationMatcher);
    }

    private void notifyStubbedAnswerLookup(Invocation invocation, StubbedInvocationMatcher exception) {
        List<StubbingLookupListener> listeners = ((CreationSettings)this.mockSettings).getStubbingLookupListeners();
        for (StubbingLookupListener listener : listeners) {
            listener.onStubbingLookup(invocation, exception);
        }
    }
}

