/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.framework;

import java.util.List;
import org.evosuite.shaded.org.mockito.Mockito;
import org.evosuite.shaded.org.mockito.MockitoAnnotations;
import org.evosuite.shaded.org.mockito.MockitoSession;
import org.evosuite.shaded.org.mockito.exceptions.misusing.RedundantListenerException;
import org.evosuite.shaded.org.mockito.internal.exceptions.Reporter;
import org.evosuite.shaded.org.mockito.internal.junit.TestFinishedEvent;
import org.evosuite.shaded.org.mockito.internal.junit.UniversalTestListener;
import org.evosuite.shaded.org.mockito.internal.util.MockitoLogger;
import org.evosuite.shaded.org.mockito.quality.Strictness;

public class DefaultMockitoSession
implements MockitoSession {
    private final List<Object> testClassInstances;
    private final String name;
    private final UniversalTestListener listener;

    public DefaultMockitoSession(List<Object> testClassInstances, String name, Strictness strictness, MockitoLogger logger2) {
        this.testClassInstances = testClassInstances;
        this.name = name;
        this.listener = new UniversalTestListener(strictness, logger2);
        try {
            Mockito.framework().addListener(this.listener);
        }
        catch (RedundantListenerException e) {
            Reporter.unfinishedMockingSession();
        }
        for (Object testClassInstance : testClassInstances) {
            MockitoAnnotations.initMocks(testClassInstance);
        }
    }

    @Override
    public void setStrictness(Strictness strictness) {
        this.listener.setStrictness(strictness);
    }

    @Override
    public void finishMocking() {
        this.finishMocking(null);
    }

    @Override
    public void finishMocking(final Throwable failure) {
        Mockito.framework().removeListener(this.listener);
        this.listener.testFinished(new TestFinishedEvent(){

            @Override
            public Throwable getFailure() {
                return failure;
            }

            @Override
            public String getTestName() {
                return DefaultMockitoSession.this.name;
            }
        });
        if (failure == null) {
            Mockito.validateMockitoUsage();
        }
    }
}

