/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.debugging;

import java.util.Collection;
import java.util.LinkedList;
import org.evosuite.shaded.org.mockito.Mockito;
import org.evosuite.shaded.org.mockito.internal.util.collections.ListUtil;
import org.evosuite.shaded.org.mockito.invocation.Invocation;
import org.evosuite.shaded.org.mockito.stubbing.Stubbing;

public class InvocationsPrinter {
    public String printInvocations(Object mock) {
        Collection<Invocation> invocations = Mockito.mockingDetails(mock).getInvocations();
        Collection<Stubbing> stubbings = Mockito.mockingDetails(mock).getStubbings();
        if (invocations.isEmpty() && stubbings.isEmpty()) {
            return "No interactions and stubbings found for mock: " + mock;
        }
        StringBuilder sb = new StringBuilder();
        int x = 1;
        for (Invocation i : invocations) {
            if (x == 1) {
                sb.append("[Mockito] Interactions of: ").append(mock).append("\n");
            }
            sb.append(" ").append(x++).append(". ").append(i.toString()).append("\n");
            sb.append("  ").append(i.getLocation()).append("\n");
            if (i.stubInfo() == null) continue;
            sb.append("   - stubbed ").append(i.stubInfo().stubbedAt()).append("\n");
        }
        LinkedList<Stubbing> unused = ListUtil.filter(stubbings, new ListUtil.Filter<Stubbing>(){

            @Override
            public boolean isOut(Stubbing s) {
                return s.wasUsed();
            }
        });
        if (unused.isEmpty()) {
            return sb.toString();
        }
        sb.append("[Mockito] Unused stubbings of: ").append(mock).append("\n");
        x = 1;
        for (Stubbing s : stubbings) {
            sb.append(" ").append(x++).append(". ").append(s.getInvocation()).append("\n");
            sb.append("  - stubbed ").append(s.getInvocation().getLocation()).append("\n");
        }
        return sb.toString();
    }
}

