/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.evosuite.shaded.org.mockito.Captor;
import org.evosuite.shaded.org.mockito.Mock;
import org.evosuite.shaded.org.mockito.exceptions.base.MockitoException;
import org.evosuite.shaded.org.mockito.internal.configuration.CaptorAnnotationProcessor;
import org.evosuite.shaded.org.mockito.internal.configuration.FieldAnnotationProcessor;
import org.evosuite.shaded.org.mockito.internal.configuration.MockAnnotationProcessor;
import org.evosuite.shaded.org.mockito.internal.exceptions.Reporter;
import org.evosuite.shaded.org.mockito.internal.util.reflection.FieldSetter;
import org.evosuite.shaded.org.mockito.plugins.AnnotationEngine;

public class IndependentAnnotationEngine
implements AnnotationEngine,
org.evosuite.shaded.org.mockito.configuration.AnnotationEngine {
    private final Map<Class<? extends Annotation>, FieldAnnotationProcessor<?>> annotationProcessorMap = new HashMap();

    public IndependentAnnotationEngine() {
        this.registerAnnotationProcessor(Mock.class, new MockAnnotationProcessor());
        this.registerAnnotationProcessor(Captor.class, new CaptorAnnotationProcessor());
    }

    private Object createMockFor(Annotation annotation, Field field) {
        return this.forAnnotation(annotation).process(annotation, field);
    }

    private <A extends Annotation> FieldAnnotationProcessor<A> forAnnotation(A annotation) {
        if (this.annotationProcessorMap.containsKey(annotation.annotationType())) {
            return this.annotationProcessorMap.get(annotation.annotationType());
        }
        return new FieldAnnotationProcessor<A>(){

            @Override
            public Object process(A annotation, Field field) {
                return null;
            }
        };
    }

    private <A extends Annotation> void registerAnnotationProcessor(Class<A> annotationClass, FieldAnnotationProcessor<A> fieldAnnotationProcessor) {
        this.annotationProcessorMap.put(annotationClass, fieldAnnotationProcessor);
    }

    @Override
    public void process(Class<?> clazz, Object testInstance) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            boolean alreadyAssigned = false;
            for (Annotation annotation : field.getAnnotations()) {
                Object mock = this.createMockFor(annotation, field);
                if (mock == null) continue;
                this.throwIfAlreadyAssigned(field, alreadyAssigned);
                alreadyAssigned = true;
                try {
                    FieldSetter.setField(testInstance, field, mock);
                }
                catch (Exception e) {
                    throw new MockitoException("Problems setting field " + field.getName() + " annotated with " + annotation, e);
                }
            }
        }
    }

    void throwIfAlreadyAssigned(Field field, boolean alreadyAssigned) {
        if (alreadyAssigned) {
            throw Reporter.moreThanOneAnnotationNotAllowed(field.getName());
        }
    }
}

