/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.result;

import java.io.IOException;
import org.evosuite.shaded.org.hsqldb.ColumnBase;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.ArrayUtil;
import org.evosuite.shaded.org.hsqldb.rowio.RowInputBinary;
import org.evosuite.shaded.org.hsqldb.rowio.RowOutputInterface;
import org.evosuite.shaded.org.hsqldb.types.ArrayType;
import org.evosuite.shaded.org.hsqldb.types.Type;

public final class ResultMetaData {
    public static final int RESULT_METADATA = 1;
    public static final int SIMPLE_RESULT_METADATA = 2;
    public static final int UPDATE_RESULT_METADATA = 3;
    public static final int PARAM_METADATA = 4;
    public static final int GENERATED_INDEX_METADATA = 5;
    public static final int GENERATED_NAME_METADATA = 6;
    private int type;
    public String[] columnLabels;
    public Type[] columnTypes;
    private int columnCount;
    private int extendedColumnCount;
    public static final ResultMetaData emptyResultMetaData = ResultMetaData.newResultMetaData(0);
    public static final ResultMetaData emptyParamMetaData = ResultMetaData.newParameterMetaData(0);
    public int[] colIndexes;
    public ColumnBase[] columns;
    public byte[] paramModes;
    public byte[] paramNullable;

    private ResultMetaData(int n) {
        this.type = n;
    }

    public static ResultMetaData newUpdateResultMetaData(Type[] typeArray) {
        ResultMetaData resultMetaData = new ResultMetaData(3);
        resultMetaData.columnTypes = new Type[typeArray.length];
        resultMetaData.columnCount = typeArray.length;
        resultMetaData.extendedColumnCount = typeArray.length;
        ArrayUtil.copyArray(typeArray, resultMetaData.columnTypes, typeArray.length);
        return resultMetaData;
    }

    public static ResultMetaData newSimpleResultMetaData(Type[] typeArray) {
        ResultMetaData resultMetaData = new ResultMetaData(2);
        resultMetaData.columnTypes = typeArray;
        resultMetaData.columnCount = typeArray.length;
        resultMetaData.extendedColumnCount = typeArray.length;
        return resultMetaData;
    }

    public static ResultMetaData newResultMetaData(int n) {
        Type[] typeArray = new Type[n];
        return ResultMetaData.newResultMetaData(typeArray, null, n, n);
    }

    public static ResultMetaData newSingleColumnMetaData(String string) {
        ResultMetaData resultMetaData = ResultMetaData.newResultMetaData(1);
        resultMetaData.columns[0] = new ColumnBase(null, null, null, string);
        resultMetaData.columns[0].setType(Type.SQL_VARCHAR_DEFAULT);
        resultMetaData.prepareData();
        return resultMetaData;
    }

    public static ResultMetaData newDoubleColumnMetaData(String string, String string2) {
        ResultMetaData resultMetaData = ResultMetaData.newResultMetaData(2);
        resultMetaData.columns[0] = new ColumnBase(null, null, null, string);
        resultMetaData.columns[0].setType(Type.SQL_VARCHAR_DEFAULT);
        resultMetaData.columns[1] = new ColumnBase(null, null, null, string2);
        resultMetaData.columns[1].setType(Type.SQL_VARCHAR_DEFAULT);
        resultMetaData.prepareData();
        return resultMetaData;
    }

    public static ResultMetaData newResultMetaData(Type[] typeArray, int[] nArray, int n, int n2) {
        ResultMetaData resultMetaData = new ResultMetaData(1);
        resultMetaData.columnLabels = new String[n];
        resultMetaData.columns = new ColumnBase[n];
        resultMetaData.columnTypes = typeArray;
        resultMetaData.colIndexes = nArray;
        resultMetaData.columnCount = n;
        resultMetaData.extendedColumnCount = n2;
        return resultMetaData;
    }

    public static ResultMetaData newParameterMetaData(int n) {
        ResultMetaData resultMetaData = new ResultMetaData(4);
        resultMetaData.columnTypes = new Type[n];
        resultMetaData.columnLabels = new String[n];
        resultMetaData.paramModes = new byte[n];
        resultMetaData.paramNullable = new byte[n];
        resultMetaData.columnCount = n;
        resultMetaData.extendedColumnCount = n;
        return resultMetaData;
    }

    public static ResultMetaData newGeneratedColumnsMetaData(int[] nArray, String[] stringArray) {
        if (nArray != null) {
            ResultMetaData resultMetaData = new ResultMetaData(5);
            resultMetaData.columnCount = nArray.length;
            resultMetaData.extendedColumnCount = nArray.length;
            resultMetaData.colIndexes = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                resultMetaData.colIndexes[i] = nArray[i] - 1;
            }
            return resultMetaData;
        }
        if (stringArray != null) {
            ResultMetaData resultMetaData = new ResultMetaData(6);
            resultMetaData.columnLabels = new String[stringArray.length];
            resultMetaData.columnCount = stringArray.length;
            resultMetaData.extendedColumnCount = stringArray.length;
            resultMetaData.columnLabels = stringArray;
            return resultMetaData;
        }
        return null;
    }

    public void prepareData() {
        if (this.columns != null) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.columnTypes[i] != null) continue;
                this.columnTypes[i] = this.columns[i].getDataType();
            }
        }
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getExtendedColumnCount() {
        return this.extendedColumnCount;
    }

    public void resetExtendedColumnCount() {
        this.extendedColumnCount = this.columnCount;
    }

    public Type[] getParameterTypes() {
        return this.columnTypes;
    }

    public String[] getGeneratedColumnNames() {
        return this.columnLabels;
    }

    public int[] getGeneratedColumnIndexes() {
        return this.colIndexes;
    }

    public boolean isTableColumn(int n) {
        String string = this.columns[n].getNameString();
        String string2 = this.columns[n].getTableNameString();
        return string2 != null && string2.length() > 0 && string != null && string.length() > 0;
    }

    private static void decodeTableColumnAttrs(int n, ColumnBase columnBase) {
        columnBase.setNullability((byte)(n & 3));
        columnBase.setIdentity((n & 4) != 0);
        columnBase.setWriteable((n & 8) != 0);
        columnBase.setSearchable((n & 0x10) != 0);
    }

    private static int encodeTableColumnAttrs(ColumnBase columnBase) {
        int n = columnBase.getNullability();
        if (columnBase.isIdentity()) {
            n |= 4;
        }
        if (columnBase.isWriteable()) {
            n |= 8;
        }
        if (columnBase.isSearchable()) {
            n |= 0x10;
        }
        return n;
    }

    private void decodeParamColumnAttrs(int n, int n2) {
        this.paramNullable[n2] = (byte)(n & 3);
        this.paramModes[n2] = (byte)(n >> 4 & 0xF);
    }

    private int encodeParamColumnAttrs(int n) {
        int n2 = this.paramModes[n] << 4;
        return n2 |= this.paramNullable[n];
    }

    ResultMetaData(RowInputBinary rowInputBinary) throws IOException {
        this.type = rowInputBinary.readInt();
        this.columnCount = rowInputBinary.readInt();
        switch (this.type) {
            case 2: 
            case 3: {
                this.columnTypes = new Type[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    this.columnTypes[i] = this.readDataTypeSimple(rowInputBinary);
                }
                return;
            }
            case 5: {
                this.colIndexes = new int[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    this.colIndexes[i] = rowInputBinary.readInt();
                }
                return;
            }
            case 6: {
                this.columnLabels = new String[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    this.columnLabels[i] = rowInputBinary.readString();
                }
                return;
            }
            case 4: {
                this.columnTypes = new Type[this.columnCount];
                this.columnLabels = new String[this.columnCount];
                this.paramModes = new byte[this.columnCount];
                this.paramNullable = new byte[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    this.columnTypes[i] = this.readDataType(rowInputBinary);
                    this.columnLabels[i] = rowInputBinary.readString();
                    this.decodeParamColumnAttrs(rowInputBinary.readByte(), i);
                }
                return;
            }
            case 1: {
                Object object;
                int n;
                this.extendedColumnCount = rowInputBinary.readInt();
                this.columnTypes = new Type[this.extendedColumnCount];
                this.columnLabels = new String[this.columnCount];
                this.columns = new ColumnBase[this.columnCount];
                if (this.columnCount != this.extendedColumnCount) {
                    this.colIndexes = new int[this.columnCount];
                }
                for (n = 0; n < this.extendedColumnCount; ++n) {
                    object = this.readDataType(rowInputBinary);
                    this.columnTypes[n] = object;
                }
                for (n = 0; n < this.columnCount; ++n) {
                    this.columnLabels[n] = rowInputBinary.readString();
                    object = rowInputBinary.readString();
                    String string = rowInputBinary.readString();
                    String string2 = rowInputBinary.readString();
                    String string3 = rowInputBinary.readString();
                    ColumnBase columnBase = new ColumnBase((String)object, string, string2, string3);
                    columnBase.setType(this.columnTypes[n]);
                    ResultMetaData.decodeTableColumnAttrs(rowInputBinary.readByte(), columnBase);
                    this.columns[n] = columnBase;
                }
                if (this.columnCount != this.extendedColumnCount) {
                    for (n = 0; n < this.columnCount; ++n) {
                        this.colIndexes[n] = rowInputBinary.readInt();
                    }
                }
                return;
            }
        }
        throw Error.runtimeError(201, "ResultMetaData");
    }

    Type readDataTypeSimple(RowInputBinary rowInputBinary) throws IOException {
        boolean bl;
        int n = rowInputBinary.readType();
        boolean bl2 = bl = n == 50;
        if (bl) {
            n = rowInputBinary.readType();
            return Type.getDefaultArrayType(n);
        }
        return Type.getDefaultType(n);
    }

    Type readDataType(RowInputBinary rowInputBinary) throws IOException {
        boolean bl;
        int n = rowInputBinary.readType();
        boolean bl2 = bl = n == 50;
        if (bl) {
            n = rowInputBinary.readType();
        }
        long l = rowInputBinary.readLong();
        int n2 = rowInputBinary.readInt();
        Type type = Type.getType(n, Type.SQL_VARCHAR.getCharacterSet(), Type.SQL_VARCHAR.getCollation(), l, n2);
        if (bl) {
            type = new ArrayType(type, 1024);
        }
        return type;
    }

    void writeDataType(RowOutputInterface rowOutputInterface, Type type) {
        rowOutputInterface.writeType(type.typeCode);
        if (type.isArrayType()) {
            rowOutputInterface.writeType(type.collectionBaseType().typeCode);
        }
        rowOutputInterface.writeLong(type.precision);
        rowOutputInterface.writeInt(type.scale);
    }

    void writeDataTypeCodes(RowOutputInterface rowOutputInterface, Type type) {
        rowOutputInterface.writeType(type.typeCode);
        if (type.isArrayType()) {
            rowOutputInterface.writeType(type.collectionBaseType().typeCode);
        }
    }

    void write(RowOutputInterface rowOutputInterface) throws IOException {
        rowOutputInterface.writeInt(this.type);
        rowOutputInterface.writeInt(this.columnCount);
        switch (this.type) {
            case 2: 
            case 3: {
                for (int i = 0; i < this.columnCount; ++i) {
                    this.writeDataTypeCodes(rowOutputInterface, this.columnTypes[i]);
                }
                return;
            }
            case 5: {
                for (int i = 0; i < this.columnCount; ++i) {
                    rowOutputInterface.writeInt(this.colIndexes[i]);
                }
                return;
            }
            case 6: {
                for (int i = 0; i < this.columnCount; ++i) {
                    rowOutputInterface.writeString(this.columnLabels[i]);
                }
                return;
            }
            case 4: {
                for (int i = 0; i < this.columnCount; ++i) {
                    this.writeDataType(rowOutputInterface, this.columnTypes[i]);
                    rowOutputInterface.writeString(this.columnLabels[i]);
                    rowOutputInterface.writeByte(this.encodeParamColumnAttrs(i));
                }
                return;
            }
            case 1: {
                ColumnBase columnBase;
                int n;
                rowOutputInterface.writeInt(this.extendedColumnCount);
                for (n = 0; n < this.extendedColumnCount; ++n) {
                    if (this.columnTypes[n] == null) {
                        columnBase = this.columns[n];
                        this.columnTypes[n] = columnBase.getDataType();
                    }
                    this.writeDataType(rowOutputInterface, this.columnTypes[n]);
                }
                for (n = 0; n < this.columnCount; ++n) {
                    columnBase = this.columns[n];
                    rowOutputInterface.writeString(this.columnLabels[n]);
                    rowOutputInterface.writeString(columnBase.getCatalogNameString());
                    rowOutputInterface.writeString(columnBase.getSchemaNameString());
                    rowOutputInterface.writeString(columnBase.getTableNameString());
                    rowOutputInterface.writeString(columnBase.getNameString());
                    rowOutputInterface.writeByte(ResultMetaData.encodeTableColumnAttrs(columnBase));
                }
                if (this.columnCount != this.extendedColumnCount) {
                    for (n = 0; n < this.colIndexes.length; ++n) {
                        rowOutputInterface.writeInt(this.colIndexes[n]);
                    }
                }
                return;
            }
        }
        throw Error.runtimeError(201, "ResultMetaData");
    }

    public ResultMetaData getNewMetaData(int[] nArray) {
        ResultMetaData resultMetaData = ResultMetaData.newResultMetaData(nArray.length);
        ArrayUtil.projectRow(this.columnLabels, nArray, resultMetaData.columnLabels);
        ArrayUtil.projectRow(this.columnTypes, nArray, resultMetaData.columnTypes);
        ArrayUtil.projectRow(this.columns, nArray, resultMetaData.columns);
        return resultMetaData;
    }

    public boolean areTypesCompatible(ResultMetaData resultMetaData) {
        if (this.columnCount != resultMetaData.columnCount) {
            return false;
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columnTypes[i].canConvertFrom(resultMetaData.columnTypes[i])) continue;
            return false;
        }
        return true;
    }
}

