/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.persist;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.evosuite.shaded.org.hsqldb.Database;
import org.evosuite.shaded.org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.evosuite.shaded.org.hsqldb.lib.InputStreamInterface;
import org.evosuite.shaded.org.hsqldb.lib.java.JavaSystem;
import org.evosuite.shaded.org.hsqldb.map.BitMap;
import org.evosuite.shaded.org.hsqldb.persist.RAFile;
import org.evosuite.shaded.org.hsqldb.persist.RAFileSimple;
import org.evosuite.shaded.org.hsqldb.persist.RandomAccessInterface;

public class RAShadowFile {
    private static final int headerSize = 12;
    final Database database;
    final String pathName;
    final RandomAccessInterface source;
    RandomAccessInterface dest;
    final int pageSize;
    final long maxSize;
    final BitMap bitMap;
    boolean zeroPageSet;
    long savedLength;
    long synchLength;
    byte[] buffer;
    HsqlByteArrayOutputStream byteArrayOutputStream;

    RAShadowFile(Database database, RandomAccessInterface randomAccessInterface, String string, long l, int n) {
        this.database = database;
        this.pathName = string;
        this.source = randomAccessInterface;
        this.pageSize = n;
        this.maxSize = l;
        int n2 = (int)(l / (long)n);
        if (l % (long)n != 0L) {
            ++n2;
        }
        this.bitMap = new BitMap(n2, false);
        this.buffer = new byte[n + 12];
        this.byteArrayOutputStream = new HsqlByteArrayOutputStream(this.buffer);
    }

    int copy(long l, int n) throws IOException {
        int n2 = 0;
        if (!this.zeroPageSet) {
            n2 += this.copy(0);
            this.bitMap.set(0);
            this.zeroPageSet = true;
        }
        if (l >= this.maxSize) {
            return n2;
        }
        long l2 = l + (long)n;
        if (l2 > this.maxSize) {
            l2 = this.maxSize;
        }
        int n3 = (int)(l / (long)this.pageSize);
        int n4 = (int)(l2 / (long)this.pageSize);
        if (l2 % (long)this.pageSize == 0L) {
            --n4;
        }
        while (n3 <= n4) {
            n2 += this.copy(n3);
            ++n3;
        }
        return n2;
    }

    private int copy(int n) throws IOException {
        if (this.bitMap.set(n) == 1) {
            return 0;
        }
        long l = (long)n * (long)this.pageSize;
        int n2 = this.pageSize;
        int n3 = this.buffer.length;
        if (this.maxSize - l < (long)this.pageSize) {
            n2 = (int)(this.maxSize - l);
        }
        if (this.dest == null) {
            this.open();
        }
        long l2 = this.dest.length();
        try {
            this.byteArrayOutputStream.reset();
            if (n2 < this.pageSize) {
                this.byteArrayOutputStream.fill(0, this.buffer.length);
                this.byteArrayOutputStream.reset();
            }
            this.byteArrayOutputStream.writeInt(this.pageSize);
            this.byteArrayOutputStream.writeLong(l);
            this.source.seek(l);
            this.source.read(this.buffer, 12, n2);
            this.dest.seek(l2);
            this.dest.write(this.buffer, 0, n3);
            this.savedLength = l2 + (long)n3;
            return 1;
        }
        catch (Throwable throwable) {
            this.bitMap.unset(n);
            this.dest.seek(0L);
            this.dest.setLength(l2);
            this.close();
            this.database.logger.logSevereEvent("shadow backup failure pos " + l + " " + n2, throwable);
            throw JavaSystem.toIOException(throwable);
        }
    }

    private void open() throws IOException {
        this.dest = this.database.logger.isStoredFileAccess() ? RAFile.newScaledRAFile(this.database, this.pathName, false, 3) : new RAFileSimple(this.database.logger, this.pathName, "rw");
    }

    void close() throws IOException {
        if (this.dest != null) {
            this.dest.synch();
            this.dest.close();
            this.dest = null;
        }
    }

    public void synch() {
        if (this.dest != null) {
            this.dest.synch();
            this.synchLength = this.savedLength;
        }
    }

    public long getSavedLength() {
        return this.savedLength;
    }

    public InputStreamInterface getInputStream() {
        return new InputStreamShadow();
    }

    private static RandomAccessInterface getStorage(Database database, String string, String string2) throws IOException {
        if (database.logger.isStoredFileAccess()) {
            return RAFile.newScaledRAFile(database, string, string2.equals("r"), 3);
        }
        return new RAFileSimple(database.logger, string, string2);
    }

    public static void restoreFile(Database database, String string, String string2) throws IOException {
        RandomAccessInterface randomAccessInterface = RAShadowFile.getStorage(database, string, "r");
        RandomAccessInterface randomAccessInterface2 = RAShadowFile.getStorage(database, string2, "rw");
        while (randomAccessInterface.getFilePointer() != randomAccessInterface.length()) {
            int n = randomAccessInterface.readInt();
            long l = randomAccessInterface.readLong();
            byte[] byArray = new byte[n];
            randomAccessInterface.read(byArray, 0, byArray.length);
            randomAccessInterface2.seek(l);
            randomAccessInterface2.write(byArray, 0, byArray.length);
        }
        randomAccessInterface.close();
        randomAccessInterface2.synch();
        randomAccessInterface2.close();
    }

    class InputStreamShadow
    implements InputStreamInterface {
        FileInputStream is;
        long limitSize = 0L;
        long fetchedSize = 0L;
        boolean initialised = false;

        InputStreamShadow() {
        }

        @Override
        public int read() throws IOException {
            if (!this.initialised) {
                this.initialise();
            }
            if (this.fetchedSize == this.limitSize) {
                return -1;
            }
            int n = this.is.read();
            if (n < 0) {
                throw new IOException("backup file not complete " + this.fetchedSize + " " + this.limitSize);
            }
            ++this.fetchedSize;
            return n;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (!this.initialised) {
                this.initialise();
            }
            if (this.fetchedSize == this.limitSize) {
                return -1;
            }
            if (this.limitSize >= 0L && this.limitSize - this.fetchedSize < (long)n2) {
                n2 = (int)(this.limitSize - this.fetchedSize);
            }
            if ((n3 = this.is.read(byArray, n, n2)) < 0) {
                throw new IOException("backup file not complete " + this.fetchedSize + " " + this.limitSize);
            }
            this.fetchedSize += (long)n3;
            return n3;
        }

        @Override
        public long skip(long l) throws IOException {
            return 0L;
        }

        @Override
        public int available() throws IOException {
            return 0;
        }

        @Override
        public void close() throws IOException {
            if (this.is != null) {
                this.is.close();
            }
        }

        @Override
        public void setSizeLimit(long l) {
            this.limitSize = l;
        }

        @Override
        public long getSizeLimit() {
            if (!this.initialised) {
                this.initialise();
            }
            return this.limitSize;
        }

        private void initialise() {
            this.limitSize = RAShadowFile.this.synchLength;
            RAShadowFile.this.database.logger.logDetailEvent("shadow file size for backup: " + this.limitSize);
            if (this.limitSize > 0L) {
                try {
                    this.is = new FileInputStream(RAShadowFile.this.pathName);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            this.initialised = true;
        }
    }
}

