/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.persist;

import org.evosuite.shaded.org.hsqldb.lib.HsqlArrayList;
import org.evosuite.shaded.org.hsqldb.persist.LobStore;

public class LobStoreMem
implements LobStore {
    final int lobBlockSize;
    int blocksInLargeBlock = 128;
    int largeBlockSize;
    HsqlArrayList byteStoreList;

    public LobStoreMem(int n) {
        this.lobBlockSize = n;
        this.largeBlockSize = n * this.blocksInLargeBlock;
        this.byteStoreList = new HsqlArrayList();
    }

    @Override
    public byte[] getBlockBytes(int n, int n2) {
        byte[] byArray = new byte[n2 * this.lobBlockSize];
        int n3 = 0;
        while (n2 > 0) {
            int n4 = n / this.blocksInLargeBlock;
            byte[] byArray2 = (byte[])this.byteStoreList.get(n4);
            int n5 = n % this.blocksInLargeBlock;
            int n6 = n2;
            if (n5 + n6 > this.blocksInLargeBlock) {
                n6 = this.blocksInLargeBlock - n5;
            }
            System.arraycopy(byArray2, n5 * this.lobBlockSize, byArray, n3 * this.lobBlockSize, n6 * this.lobBlockSize);
            n += n6;
            n3 += n6;
            n2 -= n6;
        }
        return byArray;
    }

    @Override
    public void setBlockBytes(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = n / this.blocksInLargeBlock;
            if (n4 >= this.byteStoreList.size()) {
                this.byteStoreList.add(new byte[this.largeBlockSize]);
            }
            byte[] byArray2 = (byte[])this.byteStoreList.get(n4);
            int n5 = n % this.blocksInLargeBlock;
            int n6 = n2;
            if (n5 + n6 > this.blocksInLargeBlock) {
                n6 = this.blocksInLargeBlock - n5;
            }
            System.arraycopy(byArray, n3 * this.lobBlockSize, byArray2, n5 * this.lobBlockSize, n6 * this.lobBlockSize);
            n += n6;
            n3 += n6;
            n2 -= n6;
        }
    }

    @Override
    public void setBlockBytes(byte[] byArray, long l, int n, int n2) {
        while (n2 > 0) {
            int n3 = (int)(l / (long)this.largeBlockSize);
            if (n3 >= this.byteStoreList.size()) {
                this.byteStoreList.add(new byte[this.largeBlockSize]);
            }
            byte[] byArray2 = (byte[])this.byteStoreList.get(n3);
            int n4 = (int)(l % (long)this.largeBlockSize);
            int n5 = n2;
            if (n4 + n5 > this.largeBlockSize) {
                n5 = this.largeBlockSize - n4;
            }
            System.arraycopy(byArray, n, byArray2, n4, n5);
            l += (long)n5;
            n += n5;
            n2 -= n5;
        }
    }

    @Override
    public int getBlockSize() {
        return this.lobBlockSize;
    }

    @Override
    public long getLength() {
        return (long)this.byteStoreList.size() * (long)this.largeBlockSize;
    }

    @Override
    public void setLength(long l) {
        int n = (int)(l / (long)this.largeBlockSize);
        this.byteStoreList.setSize(n + 1);
    }

    @Override
    public void close() {
        this.byteStoreList.clear();
    }

    @Override
    public void synch() {
    }
}

