/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.persist;

import org.evosuite.shaded.org.hsqldb.lib.DoubleIntIndex;
import org.evosuite.shaded.org.hsqldb.persist.DataFileCache;
import org.evosuite.shaded.org.hsqldb.persist.DataFileCacheSession;
import org.evosuite.shaded.org.hsqldb.persist.DataSpaceManager;
import org.evosuite.shaded.org.hsqldb.persist.DirectoryBlockCachedObject;
import org.evosuite.shaded.org.hsqldb.persist.TableSpaceManager;
import org.evosuite.shaded.org.hsqldb.persist.TableSpaceManagerBlocks;
import org.evosuite.shaded.org.hsqldb.persist.TableSpaceManagerSimple;
import org.evosuite.shaded.org.hsqldb.persist.TextCache;

public class DataSpaceManagerSimple
implements DataSpaceManager {
    DataFileCache cache;
    TableSpaceManager defaultSpaceManager;
    int fileBlockSize = 4096;
    long totalFragmentSize;
    int spaceIdSequence = 8;
    DoubleIntIndex lookup;

    DataSpaceManagerSimple(DataFileCache dataFileCache, boolean bl) {
        this.cache = dataFileCache;
        if (dataFileCache instanceof DataFileCacheSession) {
            this.defaultSpaceManager = new TableSpaceManagerSimple(dataFileCache);
        } else if (dataFileCache instanceof TextCache) {
            this.defaultSpaceManager = new TableSpaceManagerSimple(dataFileCache);
        } else {
            int n = dataFileCache.database.logger.propMaxFreeBlocks;
            this.defaultSpaceManager = new TableSpaceManagerBlocks(this, 7, this.fileBlockSize, n, dataFileCache.getDataFileScale(), 0);
            if (!bl) {
                this.initialiseSpaces();
                dataFileCache.spaceManagerPosition = 0L;
            }
        }
        this.totalFragmentSize = dataFileCache.lostSpaceSize;
    }

    @Override
    public TableSpaceManager getDefaultTableSpace() {
        return this.defaultSpaceManager;
    }

    @Override
    public TableSpaceManager getTableSpace(int n) {
        if (n >= this.spaceIdSequence) {
            this.spaceIdSequence = n + 1;
        }
        return this.defaultSpaceManager;
    }

    @Override
    public int getNewTableSpaceID() {
        return this.spaceIdSequence++;
    }

    @Override
    public long getFileBlocks(int n, int n2) {
        long l = this.cache.enlargeFileSpace((long)n2 * (long)this.fileBlockSize);
        return l;
    }

    @Override
    public void freeTableSpace(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(int n, DoubleIntIndex doubleIntIndex, long l, long l2, boolean bl) {
        this.totalFragmentSize += doubleIntIndex.getTotalValues() * (long)this.cache.getDataFileScale();
        if (bl) {
            if (this.cache.fileFreePosition == l2) {
                this.cache.writeLock.lock();
                try {
                    this.cache.fileFreePosition = l;
                }
                finally {
                    this.cache.writeLock.unlock();
                }
            } else {
                this.totalFragmentSize += l2 - l;
            }
            if (doubleIntIndex.size() != 0) {
                this.lookup = new DoubleIntIndex(doubleIntIndex.size(), true);
                doubleIntIndex.copyTo(this.lookup);
                doubleIntIndex.clear();
            }
        } else {
            doubleIntIndex.compactLookupAsIntervals();
            doubleIntIndex.setValuesSearchTarget();
            doubleIntIndex.sort();
            int n2 = doubleIntIndex.size() - doubleIntIndex.capacity() / 2;
            if (n2 > 0) {
                doubleIntIndex.removeRange(0, n2);
                this.totalFragmentSize -= doubleIntIndex.getTotalValues() * (long)this.cache.getDataFileScale();
            }
        }
    }

    @Override
    public long getLostBlocksSize() {
        return this.totalFragmentSize + this.defaultSpaceManager.getLostBlocksSize();
    }

    @Override
    public int getFileBlockSize() {
        return 0x100000 * this.cache.getDataFileScale() / 16;
    }

    @Override
    public boolean isModified() {
        return true;
    }

    @Override
    public void initialiseSpaces() {
        long l = this.cache.getFileFreePos();
        long l2 = (l + (long)this.fileBlockSize) / (long)this.fileBlockSize;
        long l3 = this.cache.enlargeFileSpace(l2 * (long)this.fileBlockSize - l);
        this.defaultSpaceManager.initialiseFileBlock(this.lookup, l3, this.cache.getFileFreePos());
        if (this.lookup != null) {
            this.totalFragmentSize -= this.lookup.getTotalValues() * (long)this.cache.getDataFileScale();
            this.lookup = null;
        }
    }

    @Override
    public void reset() {
        this.defaultSpaceManager.reset();
    }

    @Override
    public boolean isMultiSpace() {
        return false;
    }

    @Override
    public int getFileBlockItemCount() {
        return 65536;
    }

    @Override
    public DirectoryBlockCachedObject[] getDirectoryList() {
        return new DirectoryBlockCachedObject[0];
    }
}

