/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb;

import org.evosuite.shaded.org.hsqldb.ColumnSchema;
import org.evosuite.shaded.org.hsqldb.Expression;
import org.evosuite.shaded.org.hsqldb.ExpressionColumn;
import org.evosuite.shaded.org.hsqldb.ExpressionOp;
import org.evosuite.shaded.org.hsqldb.FunctionSQL;
import org.evosuite.shaded.org.hsqldb.HsqlException;
import org.evosuite.shaded.org.hsqldb.HsqlNameManager;
import org.evosuite.shaded.org.hsqldb.ParserDDL;
import org.evosuite.shaded.org.hsqldb.ParserDQL;
import org.evosuite.shaded.org.hsqldb.RangeGroup;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.Statement;
import org.evosuite.shaded.org.hsqldb.StatementDMQL;
import org.evosuite.shaded.org.hsqldb.Table;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.HsqlArrayList;
import org.evosuite.shaded.org.hsqldb.lib.HsqlList;
import org.evosuite.shaded.org.hsqldb.result.Result;
import org.evosuite.shaded.org.hsqldb.types.IntervalSecondData;
import org.evosuite.shaded.org.hsqldb.types.Type;

public class StatementSession
extends Statement {
    public static final StatementSession commitNoChainStatement = new StatementSession(14, new Object[]{Boolean.FALSE});
    public static final StatementSession rollbackNoChainStatement = new StatementSession(66, new Object[]{Boolean.FALSE});
    public static final StatementSession commitAndChainStatement = new StatementSession(14, new Object[]{Boolean.TRUE});
    public static final StatementSession rollbackAndChainStatement = new StatementSession(66, new Object[]{Boolean.TRUE});
    Expression[] expressions;
    Object[] arguments;

    StatementSession(Session session, ParserDQL.CompileContext compileContext, int n, Expression[] expressionArray) {
        super(n);
        this.expressions = expressionArray;
        this.isTransactionStatement = false;
        this.isLogged = false;
        Expression expression = this.expressions[0];
        switch (n) {
            case 76: {
                HsqlList hsqlList = expression.resolveColumnReferences(session, RangeGroup.emptyGroup, RangeGroup.emptyArray, null);
                ExpressionColumn.checkColumnsResolved(hsqlList);
                expression.resolveTypes(session, null);
                if (expression.dataType == null) {
                    expression.setDataType(session, Type.SQL_INTERVAL_HOUR_TO_MINUTE);
                }
                if (expression.dataType.isCharacterType()) {
                    this.expressions[0] = expression = new ExpressionOp(expression, Type.SQL_INTERVAL_HOUR_TO_MINUTE);
                }
                if (expression.dataType.typeCode != 111) {
                    throw Error.error(5563);
                }
                this.group = 2008;
                return;
            }
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: {
                this.group = 2008;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSession");
            }
        }
        expression.resolveTypes(session, null);
        switch (expression.getType()) {
            case 1: {
                break;
            }
            case 8: {
                expression.setDataType(session, Type.SQL_VARCHAR_DEFAULT);
                break;
            }
            case 28: {
                if (((FunctionSQL)expression).isValueFunction()) break;
            }
            default: {
                throw Error.error(2200);
            }
        }
        if (!expression.getDataType().isCharacterType()) {
            throw Error.error(2200);
        }
        this.setDatabaseObjects(session, compileContext);
    }

    StatementSession(int n, Object[] objectArray) {
        super(n);
        this.arguments = objectArray;
        this.isTransactionStatement = false;
        this.isLogged = false;
        switch (n) {
            case 80: {
                this.group = 2008;
                this.isLogged = true;
                break;
            }
            case 1127: {
                this.group = 2011;
                this.isLogged = true;
                break;
            }
            case 1: {
                this.group = 2003;
                break;
            }
            case 2: 
            case 16: 
            case 17: {
                this.group = 2010;
                break;
            }
            case 41: {
                this.group = 2004;
                break;
            }
            case 40: 
            case 42: 
            case 43: {
                this.group = 2003;
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 57: {
                this.group = 2003;
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                this.group = 2010;
                break;
            }
            case 22: {
                this.group = 2006;
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 82: 
            case 83: 
            case 84: 
            case 1114: 
            case 1115: 
            case 1116: 
            case 1117: {
                this.group = 2011;
                break;
            }
            case 1048: {
                this.isLogged = true;
                this.group = 2011;
                break;
            }
            case 14: 
            case 61: 
            case 66: 
            case 67: 
            case 85: 
            case 86: 
            case 1118: {
                this.group = 2005;
                break;
            }
            case 33: 
            case 1119: {
                this.group = 2008;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSession");
            }
        }
    }

    StatementSession(int n, HsqlNameManager.HsqlName[] hsqlNameArray, HsqlNameManager.HsqlName[] hsqlNameArray2) {
        super(n);
        this.isTransactionStatement = true;
        this.isLogged = false;
        this.readTableNames = hsqlNameArray;
        this.writeTableNames = hsqlNameArray2;
        switch (n) {
            case 1111: 
            case 1112: 
            case 1113: {
                this.group = 2016;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSession");
            }
        }
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        try {
            if (this.isLogged) {
                session.database.logger.writeOtherStatement(session, this.sql);
            }
        }
        catch (Throwable throwable) {
            return Result.newErrorResult(throwable, this.sql);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    Result getResult(Session var1_1) {
        var2_2 = false;
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(var1_1));
        }
        switch (this.type) {
            case 1: 
            case 2: {
                return Result.updateZeroResult;
            }
            case 14: {
                try {
                    var3_3 = (Boolean)this.arguments[0];
                    var1_1.commit(var3_3);
                    return Result.updateZeroResult;
                }
                catch (HsqlException var3_4) {
                    return Result.newErrorResult(var3_4, this.sql);
                }
            }
            case 16: 
            case 17: {
                return Result.updateZeroResult;
            }
            case 22: {
                var1_1.close();
                return Result.updateZeroResult;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                return Result.updateZeroResult;
            }
            case 1111: 
            case 1112: 
            case 1113: {
                return Result.updateZeroResult;
            }
            case 61: {
                var3_5 = (String)this.arguments[0];
                try {
                    var1_1.releaseSavepoint(var3_5);
                    return Result.updateZeroResult;
                }
                catch (HsqlException var4_28) {
                    return Result.newErrorResult(var4_28, this.sql);
                }
            }
            case 66: {
                var3_6 = (Boolean)this.arguments[0];
                var1_1.rollback(var3_6);
                return Result.updateZeroResult;
            }
            case 1118: {
                var3_7 = (String)this.arguments[0];
                try {
                    var1_1.rollbackToSavepoint(var3_7);
                    return Result.updateZeroResult;
                }
                catch (HsqlException var4_29) {
                    return Result.newErrorResult(var4_29, this.sql);
                }
            }
            case 67: {
                var3_8 = (String)this.arguments[0];
                var1_1.savepoint(var3_8);
                return Result.updateZeroResult;
            }
            case 72: {
                try {
                    var3_9 = (String)this.expressions[0].getValue(var1_1);
                    var3_9 = (String)Type.SQL_VARCHAR.trim(var1_1, var3_9, ' ', true, true);
                    if (var1_1.database.getCatalogName().name.equals(var3_9)) {
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(Error.error(4840), this.sql);
                }
                catch (HsqlException var4_30) {
                    return Result.newErrorResult(var4_30, this.sql);
                }
            }
            case 73: 
            case 74: 
            case 75: {
                return Result.updateZeroResult;
            }
            case 76: {
                var3_10 = null;
                if (this.expressions[0].getType() == 1 && this.expressions[0].getConstantValueNoCheck(var1_1) == null) {
                    var1_1.setZoneSeconds(var1_1.sessionTimeZoneSeconds);
                    return Result.updateZeroResult;
                }
                try {
                    var3_10 = this.expressions[0].getValue(var1_1);
                }
                catch (HsqlException var4_31) {
                    // empty catch block
                }
                if (!(var3_10 instanceof Result)) ** GOTO lbl81
                var4_32 = (Result)var3_10;
                if (!var4_32.isData()) ** GOTO lbl80
                var5_43 = null;
                var6_49 = false;
                if (var4_32.getNavigator().next()) {
                    var5_43 = var4_32.getNavigator().getCurrent();
                    v0 = var6_49 = var4_32.getNavigator().next() == false;
                }
                if (var6_49 && var5_43 != null && var5_43[0] != null) {
                    var3_10 = var5_43[0];
                    var4_32.getNavigator().release();
                } else {
                    var4_32.getNavigator().release();
                    return Result.newErrorResult(Error.error(3409), this.sql);
lbl80:
                    // 1 sources

                    return Result.newErrorResult(Error.error(3409), this.sql);
lbl81:
                    // 1 sources

                    if (var3_10 == null) {
                        return Result.newErrorResult(Error.error(3409), this.sql);
                    }
                }
                if (-50400L <= (var4_33 = ((IntervalSecondData)var3_10).getSeconds()) && var4_33 <= 50400L) {
                    var1_1.setZoneSeconds((int)var4_33);
                    return Result.updateZeroResult;
                }
                return Result.newErrorResult(Error.error(3409), this.sql);
            }
            case 77: {
                return Result.updateZeroResult;
            }
            case 78: {
                return Result.updateZeroResult;
            }
            case 79: {
                var4_34 = null;
                try {
                    var3_11 = (String)this.expressions[0].getValue(var1_1);
                    if (var3_11 != null) {
                        var3_11 = (String)Type.SQL_VARCHAR.trim(var1_1, var3_11, ' ', true, true);
                        var4_34 = var1_1.database.granteeManager.getRole(var3_11);
                    }
                }
                catch (HsqlException var5_44) {
                    return Result.newErrorResult(Error.error(2200), this.sql);
                }
                if (var1_1.isInMidTransaction()) {
                    return Result.newErrorResult(Error.error(3701), this.sql);
                }
                if (var4_34 == null) {
                    var1_1.setRole(null);
                }
                if (var1_1.getGrantee().hasRole(var4_34)) {
                    var1_1.setRole(var4_34);
                    return Result.updateZeroResult;
                }
                return Result.newErrorResult(Error.error(2200), this.sql);
            }
            case 80: {
                try {
                    var3_12 = this.expressions == null ? ((HsqlNameManager.HsqlName)this.arguments[0]).name : (String)this.expressions[0].getValue(var1_1);
                    var3_12 = (String)Type.SQL_VARCHAR.trim(var1_1, var3_12, ' ', true, true);
                    var4_35 = var1_1.database.schemaManager.getSchemaHsqlName(var3_12);
                    var1_1.setCurrentSchemaHsqlName(var4_35);
                    return Result.updateZeroResult;
                }
                catch (HsqlException var5_45) {
                    return Result.newErrorResult(var5_45, this.sql);
                }
            }
            case 81: {
                if (var1_1.isInMidTransaction()) {
                    return Result.newErrorResult(Error.error(3701), this.sql);
                }
                try {
                    var4_36 = null;
                    var3_13 = (String)this.expressions[0].getValue(var1_1);
                    var3_13 = (String)Type.SQL_VARCHAR.trim(var1_1, var3_13, ' ', true, true);
                    if (this.expressions[1] != null) {
                        var4_36 = (String)this.expressions[1].getValue(var1_1);
                    }
                    if ((var5_46 = var4_36 == null ? var1_1.database.userManager.get(var3_13) : var1_1.database.getUserManager().getUser(var3_13, var4_36)) == null) {
                        throw Error.error(4001);
                    }
                    this.sql = var5_46.getConnectUserSQL();
                    if (var5_46 == var1_1.getGrantee()) {
                        return Result.updateZeroResult;
                    }
                    if (var4_36 == null && !var1_1.isProcessingLog() && var5_46.isAdmin() && !var1_1.getGrantee().isAdmin()) {
                        throw Error.error(4000);
                    }
                    if (var1_1.getGrantee().canChangeAuthorisation()) {
                        var1_1.setUser(var5_46);
                        var1_1.setRole(null);
                        var1_1.resetSchema();
                        return Result.updateZeroResult;
                    }
                    throw Error.error(4000);
                }
                catch (HsqlException var3_14) {
                    return Result.newErrorResult(var3_14, this.sql);
                }
            }
            case 82: {
                try {
                    if (this.arguments[0] != null) {
                        var3_15 = ((Boolean)this.arguments[0]).booleanValue();
                        var1_1.setReadOnlyDefault((boolean)var3_15);
                    }
                    if (this.arguments[1] != null) {
                        var3_15 = (Integer)this.arguments[1];
                        var1_1.setIsolationDefault(var3_15);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException var3_16) {
                    return Result.newErrorResult(var3_16, this.sql);
                }
            }
            case 83: {
                return Result.updateZeroResult;
            }
            case 84: {
                return Result.updateZeroResult;
            }
            case 86: {
                var2_2 = true;
            }
            case 85: {
                try {
                    if (this.arguments[0] != null) {
                        var3_17 = ((Boolean)this.arguments[0]).booleanValue();
                        var1_1.setReadOnly((boolean)var3_17);
                    }
                    if (this.arguments[1] != null) {
                        var3_17 = (Integer)this.arguments[1];
                        var1_1.setIsolation(var3_17);
                    }
                    if (var2_2) {
                        var1_1.startTransaction();
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException var3_18) {
                    return Result.newErrorResult(var3_18, this.sql);
                }
            }
            case 1114: {
                var3_19 = (Boolean)this.arguments[0];
                try {
                    var1_1.setAutoCommit(var3_19);
                    return Result.updateZeroResult;
                }
                catch (HsqlException var4_37) {
                    return Result.newErrorResult(var4_37, this.sql);
                }
            }
            case 1127: {
                var3_20 = (ColumnSchema[])this.arguments[0];
                try {
                    for (var4_38 = 0; var4_38 < var3_20.length; ++var4_38) {
                        var1_1.sessionContext.addSessionVariable(var3_20[var4_38]);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException var4_39) {
                    return Result.newErrorResult(var4_39, this.sql);
                }
            }
            case 1115: {
                var3_21 = (String)this.arguments[0];
                var4_40 = (Boolean)this.arguments[1];
                var1_1.setFeature(var3_21, var4_40);
                return Result.updateZeroResult;
            }
            case 1116: {
                var3_22 = (Integer)this.arguments[0];
                var1_1.setSQLMaxRows(var3_22);
                return Result.updateZeroResult;
            }
            case 1117: {
                var3_23 = (Integer)this.arguments[0];
                var1_1.setResultMemoryRowCount(var3_23);
                return Result.updateZeroResult;
            }
            case 1048: {
                try {
                    var3_24 = (Boolean)this.arguments[0];
                    var1_1.setIgnoreCase(var3_24);
                    return Result.updateZeroResult;
                }
                catch (HsqlException var3_25) {
                    return Result.newErrorResult(var3_25, this.sql);
                }
            }
            case 1119: {
                var3_26 = (Table)this.arguments[0];
                var4_41 = (HsqlArrayList)this.arguments[1];
                var5_47 = (StatementDMQL)this.arguments[3];
                var6_50 = (Boolean)this.arguments[4];
                try {
                    if (var4_41.size() != 0) {
                        var3_26 = ParserDDL.addTableConstraintDefinitions(var1_1, var3_26, var4_41, null, false);
                    }
                    var3_26.compile(var1_1, null);
                    try {
                        var1_1.sessionContext.addSessionTable(var3_26);
                    }
                    catch (HsqlException var7_51) {
                        if (var6_50 != null && var6_50.booleanValue()) {
                            return Result.updateZeroResult;
                        }
                        return Result.newErrorResult(var7_51, this.sql);
                    }
                    if (var3_26.hasLobColumn) {
                        throw Error.error(5534);
                    }
                    if (var5_47 != null) {
                        var7_52 = var5_47.execute(var1_1);
                        var3_26.insertIntoTable(var1_1, var7_52);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException var7_53) {
                    return Result.newErrorResult(var7_53, this.sql);
                }
            }
            case 33: {
                var3_27 = (HsqlNameManager.HsqlName)this.arguments[0];
                var4_42 = (Boolean)this.arguments[1];
                var5_48 = var1_1.sessionContext.findSessionTable(var3_27.name);
                if (var5_48 == null) {
                    if (var4_42.booleanValue()) {
                        return Result.updateZeroResult;
                    }
                    throw Error.error(5501, var3_27.name);
                }
                var1_1.sessionData.persistentStoreCollection.removeStore(var5_48);
                var1_1.sessionContext.dropSessionTable(var3_27.name);
                return Result.updateZeroResult;
            }
        }
        throw Error.runtimeError(201, "StatementSession");
    }

    @Override
    public boolean isAutoCommitStatement() {
        return false;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }

    @Override
    public boolean isCatalogLock(int n) {
        return false;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }

    static {
        StatementSession.commitNoChainStatement.sql = "COMMIT";
        StatementSession.commitAndChainStatement.sql = "COMMIT CHAIN";
        StatementSession.rollbackNoChainStatement.sql = "ROLLBACK";
        StatementSession.rollbackAndChainStatement.sql = "ROLLBACK CHAIN";
        StatementSession.commitNoChainStatement.compileTimestamp = Long.MAX_VALUE;
        StatementSession.commitAndChainStatement.compileTimestamp = Long.MAX_VALUE;
        StatementSession.rollbackNoChainStatement.compileTimestamp = Long.MAX_VALUE;
        StatementSession.rollbackAndChainStatement.compileTimestamp = Long.MAX_VALUE;
    }
}

