/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb;

import org.evosuite.shaded.org.hsqldb.Expression;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.types.Type;

public class ExpressionValue
extends Expression {
    ExpressionValue(Object object, Type type) {
        super(1);
        this.nodes = Expression.emptyArray;
        this.dataType = type;
        this.valueData = object;
    }

    @Override
    public byte getNullability() {
        return this.valueData == null ? (byte)1 : 0;
    }

    @Override
    public String getSQL() {
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
        }
        throw Error.runtimeError(201, "ExpressionValue");
    }

    @Override
    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        switch (this.opType) {
            case 1: {
                stringBuffer.append("VALUE = ").append(this.dataType.convertToSQLString(this.valueData));
                stringBuffer.append(", TYPE = ").append(this.dataType.getNameString());
                return stringBuffer.toString();
            }
        }
        throw Error.runtimeError(201, "ExpressionValue");
    }

    @Override
    Object getValue(Session session, Type type) {
        if (this.dataType == type || this.valueData == null) {
            return this.valueData;
        }
        return type.convertToType(session, this.valueData, this.dataType);
    }

    @Override
    public Object getValue(Session session) {
        return this.valueData;
    }
}

