/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.tool.schema.extract.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.evosuite.shaded.org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.evosuite.shaded.org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.evosuite.shaded.org.hibernate.tool.schema.extract.internal.SequenceInformationImpl;
import org.evosuite.shaded.org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.evosuite.shaded.org.hibernate.tool.schema.extract.spi.SequenceInformation;
import org.evosuite.shaded.org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;

public class SequenceInformationExtractorH2DatabaseImpl
implements SequenceInformationExtractor {
    public static final SequenceInformationExtractorH2DatabaseImpl INSTANCE = new SequenceInformationExtractorH2DatabaseImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<SequenceInformation> extractMetadata(ExtractionContext extractionContext) throws SQLException {
        IdentifierHelper identifierHelper = extractionContext.getJdbcEnvironment().getIdentifierHelper();
        Statement statement = extractionContext.getJdbcConnection().createStatement();
        try {
            ArrayList<SequenceInformation> arrayList;
            ResultSet resultSet = statement.executeQuery("select SEQUENCE_CATALOG, SEQUENCE_SCHEMA, SEQUENCE_NAME, INCREMENT from information_schema.sequences");
            try {
                ArrayList<SequenceInformation> sequenceInformationList = new ArrayList<SequenceInformation>();
                while (resultSet.next()) {
                    sequenceInformationList.add(new SequenceInformationImpl(new QualifiedSequenceName(identifierHelper.toIdentifier(resultSet.getString("SEQUENCE_CATALOG")), identifierHelper.toIdentifier(resultSet.getString("SEQUENCE_SCHEMA")), identifierHelper.toIdentifier(resultSet.getString("SEQUENCE_NAME"))), resultSet.getInt("INCREMENT")));
                }
                arrayList = sequenceInformationList;
            }
            catch (Throwable throwable) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return arrayList;
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
    }
}

