/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.jpa.internal;

import java.io.Serializable;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.spi.LoadState;
import org.evosuite.shaded.org.hibernate.Hibernate;
import org.evosuite.shaded.org.hibernate.MappingException;
import org.evosuite.shaded.org.hibernate.engine.spi.EntityEntry;
import org.evosuite.shaded.org.hibernate.engine.spi.ManagedEntity;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.jpa.internal.util.PersistenceUtilHelper;
import org.evosuite.shaded.org.hibernate.persister.entity.EntityPersister;
import org.evosuite.shaded.org.hibernate.proxy.HibernateProxy;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class PersistenceUnitUtilImpl
implements PersistenceUnitUtil,
Serializable {
    private static final Logger log = Logger.getLogger(PersistenceUnitUtilImpl.class);
    private final SessionFactoryImplementor sessionFactory;
    private final transient PersistenceUtilHelper.MetadataCache cache = new PersistenceUtilHelper.MetadataCache();

    public PersistenceUnitUtilImpl(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public boolean isLoaded(Object entity, String attributeName) {
        log.debug("PersistenceUnitUtil#isLoaded is not always accurate; consider using EntityManager#contains instead");
        LoadState state = PersistenceUtilHelper.isLoadedWithoutReference(entity, attributeName, this.cache);
        if (state == LoadState.LOADED) {
            return true;
        }
        if (state == LoadState.NOT_LOADED) {
            return false;
        }
        return PersistenceUtilHelper.isLoadedWithReference(entity, attributeName, this.cache) != LoadState.NOT_LOADED;
    }

    @Override
    public boolean isLoaded(Object entity) {
        log.debug("PersistenceUnitUtil#isLoaded is not always accurate; consider using EntityManager#contains instead");
        return PersistenceUtilHelper.isLoaded(entity) != LoadState.NOT_LOADED;
    }

    @Override
    public Object getIdentifier(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Passed entity cannot be null");
        }
        if (entity instanceof HibernateProxy) {
            return ((HibernateProxy)entity).getHibernateLazyInitializer().getIdentifier();
        }
        if (entity instanceof ManagedEntity) {
            EntityEntry entityEntry = ((ManagedEntity)entity).$$_hibernate_getEntityEntry();
            if (entityEntry != null) {
                return entityEntry.getId();
            }
            log.debug("javax.persistence.PersistenceUnitUtil.getIdentifier may not be able to read identifier of a detached entity");
            return this.getIdentifierFromPersister(entity);
        }
        log.debugf("javax.persistence.PersistenceUnitUtil.getIdentifier is only intended to work with enhanced entities (although Hibernate also adapts this support to its proxies); however the passed entity was not enhanced (nor a proxy).. may not be able to read identifier", new Object[0]);
        return this.getIdentifierFromPersister(entity);
    }

    private Object getIdentifierFromPersister(Object entity) {
        EntityPersister persister;
        Class entityClass = Hibernate.getClass(entity);
        try {
            persister = this.sessionFactory.getMetamodel().entityPersister(entityClass);
            if (persister == null) {
                throw new IllegalArgumentException(entityClass.getName() + " is not an entity");
            }
        }
        catch (MappingException ex) {
            throw new IllegalArgumentException(entityClass.getName() + " is not an entity", ex);
        }
        return persister.getIdentifier(entity, null);
    }
}

