/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.jpa.event.internal.jpa;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.evosuite.shaded.org.hibernate.jpa.event.spi.jpa.Listener;
import org.evosuite.shaded.org.hibernate.jpa.event.spi.jpa.ListenerFactory;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class ListenerFactoryBeanManagerStandardImpl
implements ListenerFactory {
    private static final Logger log = Logger.getLogger(ListenerFactoryBeanManagerStandardImpl.class);
    private final BeanManager beanManager;
    private final Map<Class, ListenerImpl> listenerMap = new ConcurrentHashMap<Class, ListenerImpl>();

    public static ListenerFactoryBeanManagerStandardImpl fromBeanManagerReference(Object reference) {
        if (!BeanManager.class.isInstance(reference)) {
            throw new IllegalArgumentException("Expecting BeanManager reference that implements CDI BeanManager contract : " + reference);
        }
        return new ListenerFactoryBeanManagerStandardImpl((BeanManager)reference);
    }

    public ListenerFactoryBeanManagerStandardImpl(BeanManager beanManager) {
        this.beanManager = beanManager;
        log.debugf("Standard access requested to CDI BeanManager : " + beanManager, new Object[0]);
    }

    @Override
    public <T> Listener<T> buildListener(Class<T> listenerClass) {
        ListenerImpl listenerImpl = this.listenerMap.get(listenerClass);
        if (listenerImpl == null) {
            listenerImpl = new ListenerImpl(listenerClass);
            this.listenerMap.put(listenerClass, listenerImpl);
        }
        return listenerImpl;
    }

    @Override
    public void release() {
        for (ListenerImpl listenerImpl : this.listenerMap.values()) {
            listenerImpl.release();
        }
        this.listenerMap.clear();
    }

    private class ListenerImpl<T>
    implements Listener<T> {
        private final InjectionTarget<T> injectionTarget;
        private final CreationalContext<T> creationalContext;
        private final T listenerInstance;

        private ListenerImpl(Class<T> listenerClass) {
            AnnotatedType<T> annotatedType = ListenerFactoryBeanManagerStandardImpl.this.beanManager.createAnnotatedType(listenerClass);
            this.injectionTarget = ListenerFactoryBeanManagerStandardImpl.this.beanManager.createInjectionTarget(annotatedType);
            this.creationalContext = ListenerFactoryBeanManagerStandardImpl.this.beanManager.createCreationalContext(null);
            this.listenerInstance = this.injectionTarget.produce(this.creationalContext);
            this.injectionTarget.inject(this.listenerInstance, this.creationalContext);
            this.injectionTarget.postConstruct(this.listenerInstance);
        }

        @Override
        public T getListener() {
            return this.listenerInstance;
        }

        public void release() {
            this.injectionTarget.preDestroy(this.listenerInstance);
            this.injectionTarget.dispose(this.listenerInstance);
            this.creationalContext.release();
        }
    }
}

