/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.hql.spi.id;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.shaded.org.hibernate.JDBCException;
import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.JdbcServices;
import org.evosuite.shaded.org.hibernate.engine.spi.QueryParameters;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.AbstractRestrictableStatement;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.FromElement;
import org.evosuite.shaded.org.hibernate.hql.spi.id.AbstractTableBasedBulkIdHandler;
import org.evosuite.shaded.org.hibernate.param.ParameterSpecification;
import org.evosuite.shaded.org.hibernate.persister.entity.Queryable;

public abstract class AbstractIdsBulkIdHandler
extends AbstractTableBasedBulkIdHandler {
    private final Queryable targetedPersister;
    private final String idSelect;
    private final List<ParameterSpecification> idSelectParameterSpecifications;

    public AbstractIdsBulkIdHandler(SessionFactoryImplementor sessionFactory, HqlSqlWalker walker) {
        super(sessionFactory, walker);
        AbstractRestrictableStatement statement = (AbstractRestrictableStatement)walker.getAST();
        FromElement fromElement = statement.getFromClause().getFromElement();
        this.targetedPersister = fromElement.getQueryable();
        AbstractTableBasedBulkIdHandler.ProcessedWhereClause processedWhereClause = this.processWhereClause(statement.getWhereClause());
        this.idSelectParameterSpecifications = processedWhereClause.getIdSelectParameterSpecifications();
        String bulkTargetAlias = fromElement.getTableAlias();
        this.idSelect = this.generateIdSelect(bulkTargetAlias, processedWhereClause).toStatementString();
    }

    @Override
    public Queryable getTargetedQueryable() {
        return this.targetedPersister;
    }

    protected Dialect dialect() {
        return this.factory().getServiceRegistry().getService(JdbcServices.class).getDialect();
    }

    protected JDBCException convert(SQLException e, String message, String sql) {
        throw this.factory().getServiceRegistry().getService(JdbcServices.class).getSqlExceptionHelper().convert(e, message, sql);
    }

    protected List<Object[]> selectIds(SharedSessionContractImplementor session, QueryParameters queryParameters) {
        ArrayList<Object[]> ids = new ArrayList<Object[]>();
        try (PreparedStatement ps = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(this.idSelect, false);){
            int position = 1;
            for (ParameterSpecification parameterSpecification : this.idSelectParameterSpecifications) {
                position += parameterSpecification.bind(ps, queryParameters, session, position);
            }
            ResultSet rs = session.getJdbcCoordinator().getResultSetReturn().extract(ps);
            while (rs.next()) {
                Object[] result = new Object[this.targetedPersister.getIdentifierColumnNames().length];
                for (String columnName : this.targetedPersister.getIdentifierColumnNames()) {
                    Object column;
                    result[rs.findColumn((String)columnName) - 1] = column = rs.getObject(columnName);
                }
                ids.add(result);
            }
        }
        catch (SQLException e) {
            throw this.convert(e, "could not select ids for bulk operation", this.idSelect);
        }
        return ids;
    }
}

