/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.dialect.unique;

import java.util.Iterator;
import org.evosuite.shaded.org.hibernate.boot.Metadata;
import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.dialect.unique.DefaultUniqueDelegate;
import org.evosuite.shaded.org.hibernate.mapping.Column;
import org.evosuite.shaded.org.hibernate.mapping.Index;
import org.evosuite.shaded.org.hibernate.mapping.UniqueKey;

public class DB2UniqueDelegate
extends DefaultUniqueDelegate {
    public DB2UniqueDelegate(Dialect dialect) {
        super(dialect);
    }

    @Override
    public String getAlterTableToAddUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata) {
        if (this.hasNullable(uniqueKey)) {
            return Index.buildSqlCreateIndexString(this.dialect, uniqueKey.getName(), uniqueKey.getTable(), uniqueKey.columnIterator(), uniqueKey.getColumnOrderMap(), true, metadata);
        }
        return super.getAlterTableToAddUniqueKeyCommand(uniqueKey, metadata);
    }

    @Override
    public String getAlterTableToDropUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata) {
        if (this.hasNullable(uniqueKey)) {
            return Index.buildSqlDropIndexString(uniqueKey.getName(), metadata.getDatabase().getJdbcEnvironment().getQualifiedObjectNameFormatter().format(uniqueKey.getTable().getQualifiedTableName(), metadata.getDatabase().getJdbcEnvironment().getDialect()));
        }
        return super.getAlterTableToDropUniqueKeyCommand(uniqueKey, metadata);
    }

    private boolean hasNullable(UniqueKey uniqueKey) {
        Iterator<Column> iter = uniqueKey.columnIterator();
        while (iter.hasNext()) {
            if (!iter.next().isNullable()) continue;
            return true;
        }
        return false;
    }
}

