/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.dialect.pagination;

import java.util.Locale;
import org.evosuite.shaded.org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.evosuite.shaded.org.hibernate.dialect.pagination.LimitHelper;
import org.evosuite.shaded.org.hibernate.engine.spi.RowSelection;

public class Informix10LimitHandler
extends AbstractLimitHandler {
    public static final Informix10LimitHandler INSTANCE = new Informix10LimitHandler();

    private Informix10LimitHandler() {
    }

    @Override
    public String processSql(String sql, RowSelection selection) {
        boolean hasOffset = LimitHelper.hasFirstRow(selection);
        String sqlOffset = hasOffset ? " SKIP " + selection.getFirstRow() : "";
        String sqlLimit = " FIRST " + this.getMaxOrLimit(selection);
        String sqlOffsetLimit = sqlOffset + sqlLimit;
        String result = new StringBuilder(sql.length() + 10).append(sql).insert(sql.toLowerCase(Locale.ROOT).indexOf("select") + 6, sqlOffsetLimit).toString();
        return result;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean bindLimitParametersFirst() {
        return true;
    }

    @Override
    public boolean useMaxForLimit() {
        return false;
    }

    @Override
    public boolean supportsLimitOffset() {
        return true;
    }

    @Override
    public boolean supportsVariableLimit() {
        return false;
    }
}

