/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.bytebuddy;

import java.util.Collection;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.evosuite.shaded.net.bytebuddy.asm.Advice;
import org.evosuite.shaded.net.bytebuddy.description.annotation.AnnotationDescription;
import org.evosuite.shaded.net.bytebuddy.description.annotation.AnnotationValue;
import org.evosuite.shaded.net.bytebuddy.description.field.FieldDescription;
import org.evosuite.shaded.net.bytebuddy.description.method.MethodDescription;
import org.evosuite.shaded.net.bytebuddy.description.type.TypeDescription;
import org.evosuite.shaded.net.bytebuddy.dynamic.scaffold.FieldLocator;
import org.evosuite.shaded.net.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.evosuite.shaded.net.bytebuddy.implementation.Implementation;
import org.evosuite.shaded.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.evosuite.shaded.net.bytebuddy.jar.asm.MethodVisitor;
import org.evosuite.shaded.net.bytebuddy.jar.asm.Type;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.bytebuddy.ByteBuddyEnhancementContext;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.bytebuddy.CodeTemplates;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerImpl;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;

class BiDirectionalAssociationHandler
implements Implementation {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(BiDirectionalAssociationHandler.class);
    private final Implementation delegate;
    private final TypeDescription targetEntity;
    private final TypeDescription targetType;
    private final String mappedBy;

    static Implementation wrap(TypeDescription managedCtClass, ByteBuddyEnhancementContext enhancementContext, FieldDescription persistentField, Implementation implementation) {
        if (!enhancementContext.doBiDirectionalAssociationManagement(persistentField)) {
            return implementation;
        }
        TypeDescription targetEntity = BiDirectionalAssociationHandler.getTargetEntityClass(managedCtClass, persistentField);
        if (targetEntity == null) {
            return implementation;
        }
        String mappedBy = BiDirectionalAssociationHandler.getMappedBy(persistentField, targetEntity, enhancementContext);
        if (mappedBy == null || mappedBy.isEmpty()) {
            log.infof("Could not find bi-directional association for field [%s#%s]", (Object)managedCtClass.getName(), (Object)persistentField.getName());
            return implementation;
        }
        TypeDescription targetType = FieldLocator.ForClassHierarchy.Factory.INSTANCE.make(targetEntity).locate(mappedBy).getField().getType().asErasure();
        if (EnhancerImpl.isAnnotationPresent(persistentField, OneToOne.class)) {
            implementation = Advice.withCustomMapping().bind(CodeTemplates.FieldValue.class, persistentField).bind(CodeTemplates.MappedBy.class, mappedBy).to(CodeTemplates.OneToOneHandler.class).wrap(implementation);
        }
        if (EnhancerImpl.isAnnotationPresent(persistentField, OneToMany.class)) {
            implementation = Advice.withCustomMapping().bind(CodeTemplates.FieldValue.class, persistentField).bind(CodeTemplates.MappedBy.class, mappedBy).to(persistentField.getType().asErasure().isAssignableTo(Map.class) ? CodeTemplates.OneToManyOnMapHandler.class : CodeTemplates.OneToManyOnCollectionHandler.class).wrap(implementation);
        }
        if (EnhancerImpl.isAnnotationPresent(persistentField, ManyToOne.class)) {
            implementation = Advice.withCustomMapping().bind(CodeTemplates.FieldValue.class, persistentField).bind(CodeTemplates.MappedBy.class, mappedBy).to(CodeTemplates.ManyToOneHandler.class).wrap(implementation);
        }
        if (EnhancerImpl.isAnnotationPresent(persistentField, ManyToMany.class)) {
            if (persistentField.getType().asErasure().isAssignableTo(Map.class) || targetType.isAssignableTo(Map.class)) {
                log.infof("Bi-directional association for field [%s#%s] not managed: @ManyToMany in java.util.Map attribute not supported ", (Object)managedCtClass.getName(), (Object)persistentField.getName());
                return implementation;
            }
            implementation = Advice.withCustomMapping().bind(CodeTemplates.FieldValue.class, persistentField).bind(CodeTemplates.MappedBy.class, mappedBy).to(CodeTemplates.ManyToManyHandler.class).wrap(implementation);
        }
        return new BiDirectionalAssociationHandler(implementation, targetEntity, targetType, mappedBy);
    }

    public static TypeDescription getTargetEntityClass(TypeDescription managedCtClass, FieldDescription persistentField) {
        try {
            AnnotationDescription.Loadable<OneToOne> oto = EnhancerImpl.getAnnotation(persistentField, OneToOne.class);
            AnnotationDescription.Loadable<OneToMany> otm = EnhancerImpl.getAnnotation(persistentField, OneToMany.class);
            AnnotationDescription.Loadable<ManyToOne> mto = EnhancerImpl.getAnnotation(persistentField, ManyToOne.class);
            AnnotationDescription.Loadable<ManyToMany> mtm = EnhancerImpl.getAnnotation(persistentField, ManyToMany.class);
            if (oto == null && otm == null && mto == null && mtm == null) {
                return null;
            }
            AnnotationValue<?, ?> targetClass = null;
            if (oto != null) {
                targetClass = oto.getValue(new MethodDescription.ForLoadedMethod(OneToOne.class.getDeclaredMethod("targetEntity", new Class[0])));
            }
            if (otm != null) {
                targetClass = otm.getValue(new MethodDescription.ForLoadedMethod(OneToMany.class.getDeclaredMethod("targetEntity", new Class[0])));
            }
            if (mto != null) {
                targetClass = mto.getValue(new MethodDescription.ForLoadedMethod(ManyToOne.class.getDeclaredMethod("targetEntity", new Class[0])));
            }
            if (mtm != null) {
                targetClass = mtm.getValue(new MethodDescription.ForLoadedMethod(ManyToMany.class.getDeclaredMethod("targetEntity", new Class[0])));
            }
            if (targetClass == null) {
                log.infof("Could not find type of bi-directional association for field [%s#%s]", (Object)managedCtClass.getName(), (Object)persistentField.getName());
                return null;
            }
            if (!targetClass.resolve(TypeDescription.class).represents(Void.TYPE)) {
                return targetClass.resolve(TypeDescription.class);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return BiDirectionalAssociationHandler.entityType(BiDirectionalAssociationHandler.target(persistentField));
    }

    private static TypeDescription.Generic target(FieldDescription persistentField) {
        AnnotationDescription.Loadable<Access> access = persistentField.getDeclaringType().asErasure().getDeclaredAnnotations().ofType(Access.class);
        if (access != null && access.loadSilent().value() == AccessType.FIELD) {
            return persistentField.getType();
        }
        MethodDescription getter = EnhancerImpl.getterOf(persistentField);
        if (getter == null) {
            return persistentField.getType();
        }
        return getter.getReturnType();
    }

    private static String getMappedBy(FieldDescription target, TypeDescription targetEntity, ByteBuddyEnhancementContext context) {
        String mappedBy = BiDirectionalAssociationHandler.getMappedByNotManyToMany(target);
        if (mappedBy == null || mappedBy.isEmpty()) {
            return BiDirectionalAssociationHandler.getMappedByManyToMany(target, targetEntity, context);
        }
        return mappedBy;
    }

    private static String getMappedByNotManyToMany(FieldDescription target) {
        try {
            AnnotationDescription.Loadable<OneToOne> oto = EnhancerImpl.getAnnotation(target, OneToOne.class);
            if (oto != null) {
                return oto.getValue(new MethodDescription.ForLoadedMethod(OneToOne.class.getDeclaredMethod("mappedBy", new Class[0]))).resolve(String.class);
            }
            AnnotationDescription.Loadable<OneToMany> otm = EnhancerImpl.getAnnotation(target, OneToMany.class);
            if (otm != null) {
                return otm.getValue(new MethodDescription.ForLoadedMethod(OneToMany.class.getDeclaredMethod("mappedBy", new Class[0]))).resolve(String.class);
            }
            AnnotationDescription.Loadable<ManyToMany> mtm = EnhancerImpl.getAnnotation(target, ManyToMany.class);
            if (mtm != null) {
                return mtm.getValue(new MethodDescription.ForLoadedMethod(ManyToMany.class.getDeclaredMethod("mappedBy", new Class[0]))).resolve(String.class);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static String getMappedByManyToMany(FieldDescription target, TypeDescription targetEntity, ByteBuddyEnhancementContext context) {
        for (FieldDescription fieldDescription : targetEntity.getDeclaredFields()) {
            if (!context.isPersistentField(fieldDescription) || !target.getName().equals(BiDirectionalAssociationHandler.getMappedByNotManyToMany(fieldDescription)) || !target.getDeclaringType().asErasure().isAssignableTo(BiDirectionalAssociationHandler.entityType(fieldDescription.getType()))) continue;
            log.debugf("mappedBy association for field [%s#%s] is [%s#%s]", target.getDeclaringType().asErasure().getName(), target.getName(), targetEntity.getName(), fieldDescription.getName());
            return fieldDescription.getName();
        }
        return null;
    }

    private static TypeDescription entityType(TypeDescription.Generic type) {
        if (type.getSort().isParameterized()) {
            if (type.asErasure().isAssignableTo(Collection.class)) {
                return ((TypeDescription.Generic)type.getTypeArguments().get(0)).asErasure();
            }
            if (type.asErasure().isAssignableTo(Map.class)) {
                return ((TypeDescription.Generic)type.getTypeArguments().get(1)).asErasure();
            }
        }
        return type.asErasure();
    }

    private BiDirectionalAssociationHandler(Implementation delegate, TypeDescription targetEntity, TypeDescription targetType, String mappedBy) {
        this.delegate = delegate;
        this.targetEntity = targetEntity;
        this.targetType = targetType;
        this.mappedBy = mappedBy;
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new WrappingAppender(this.delegate.appender(implementationTarget));
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return this.delegate.prepare(instrumentedType);
    }

    private class WrappingAppender
    implements ByteCodeAppender {
        private final ByteCodeAppender delegate;

        private WrappingAppender(ByteCodeAppender delegate) {
            this.delegate = delegate;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            return this.delegate.apply(new MethodVisitor(327680, methodVisitor){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    if (owner.startsWith(Type.getInternalName(CodeTemplates.class))) {
                        if (name.equals("getter")) {
                            super.visitTypeInsn(192, BiDirectionalAssociationHandler.this.targetEntity.getInternalName());
                            super.visitMethodInsn(182, BiDirectionalAssociationHandler.this.targetEntity.getInternalName(), "$$_hibernate_read_" + BiDirectionalAssociationHandler.this.mappedBy, Type.getMethodDescriptor(Type.getType(BiDirectionalAssociationHandler.this.targetType.getDescriptor()), new Type[0]), false);
                            return;
                        } else if (name.equals("setterSelf")) {
                            super.visitInsn(87);
                            super.visitTypeInsn(192, BiDirectionalAssociationHandler.this.targetEntity.getInternalName());
                            super.visitVarInsn(25, 0);
                            super.visitMethodInsn(182, BiDirectionalAssociationHandler.this.targetEntity.getInternalName(), "$$_hibernate_write_" + BiDirectionalAssociationHandler.this.mappedBy, Type.getMethodDescriptor(Type.getType(Void.TYPE), Type.getType(BiDirectionalAssociationHandler.this.targetType.getDescriptor())), false);
                            return;
                        } else {
                            if (!name.equals("setterNull")) throw new EnhancementException("Unknown template method: " + name);
                            super.visitInsn(87);
                            super.visitTypeInsn(192, BiDirectionalAssociationHandler.this.targetEntity.getInternalName());
                            super.visitInsn(1);
                            super.visitMethodInsn(182, BiDirectionalAssociationHandler.this.targetEntity.getInternalName(), "$$_hibernate_write_" + BiDirectionalAssociationHandler.this.mappedBy, Type.getMethodDescriptor(Type.getType(Void.TYPE), Type.getType(BiDirectionalAssociationHandler.this.targetType.getDescriptor())), false);
                        }
                        return;
                    } else {
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                    }
                }
            }, implementationContext, instrumentedMethod);
        }
    }
}

