/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.boot.archive.scan.spi;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.persistence.Converter;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.evosuite.shaded.javassist.bytecode.AnnotationsAttribute;
import org.evosuite.shaded.javassist.bytecode.ClassFile;
import org.evosuite.shaded.org.hibernate.boot.archive.scan.internal.ClassDescriptorImpl;
import org.evosuite.shaded.org.hibernate.boot.archive.scan.internal.ScanResultCollector;
import org.evosuite.shaded.org.hibernate.boot.archive.scan.spi.ClassDescriptor;
import org.evosuite.shaded.org.hibernate.boot.archive.spi.ArchiveContext;
import org.evosuite.shaded.org.hibernate.boot.archive.spi.ArchiveEntry;
import org.evosuite.shaded.org.hibernate.boot.archive.spi.ArchiveEntryHandler;
import org.evosuite.shaded.org.hibernate.boot.archive.spi.ArchiveException;

public class ClassFileArchiveEntryHandler
implements ArchiveEntryHandler {
    private final ScanResultCollector resultCollector;

    public ClassFileArchiveEntryHandler(ScanResultCollector resultCollector) {
        this.resultCollector = resultCollector;
    }

    @Override
    public void handleEntry(ArchiveEntry entry, ArchiveContext context) {
        ClassFile classFile = this.toClassFile(entry);
        ClassDescriptor classDescriptor = this.toClassDescriptor(classFile, entry);
        if (classDescriptor.getCategorization() == ClassDescriptor.Categorization.OTHER) {
            return;
        }
        this.resultCollector.handleClass(classDescriptor, context.isRootUrl());
    }

    private ClassFile toClassFile(ArchiveEntry entry) {
        InputStream inputStream = entry.getStreamAccess().accessInputStream();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            ClassFile classFile = new ClassFile(dataInputStream);
            return classFile;
        }
        catch (IOException e) {
            throw new ArchiveException("Could not build ClassFile", e);
        }
        finally {
            try {
                dataInputStream.close();
            }
            catch (Exception exception) {}
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private ClassDescriptor toClassDescriptor(ClassFile classFile, ArchiveEntry entry) {
        ClassDescriptor.Categorization categorization = ClassDescriptor.Categorization.OTHER;
        AnnotationsAttribute visibleAnnotations = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        if (visibleAnnotations != null) {
            if (visibleAnnotations.getAnnotation(Entity.class.getName()) != null || visibleAnnotations.getAnnotation(MappedSuperclass.class.getName()) != null || visibleAnnotations.getAnnotation(Embeddable.class.getName()) != null) {
                categorization = ClassDescriptor.Categorization.MODEL;
            } else if (visibleAnnotations.getAnnotation(Converter.class.getName()) != null) {
                categorization = ClassDescriptor.Categorization.CONVERTER;
            }
        }
        return new ClassDescriptorImpl(classFile.getName(), categorization, entry.getStreamAccess());
    }
}

