/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate;

import java.util.Locale;
import java.util.Map;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.jboss.logging.Logger;

public enum MultiTenancyStrategy {
    DISCRIMINATOR,
    SCHEMA,
    DATABASE,
    NONE;

    private static final CoreMessageLogger LOG;

    public boolean requiresMultiTenantConnectionProvider() {
        return this == DATABASE || this == SCHEMA;
    }

    public static MultiTenancyStrategy determineMultiTenancyStrategy(Map properties) {
        Object strategy = properties.get("hibernate.multiTenancy");
        if (strategy == null) {
            return NONE;
        }
        if (MultiTenancyStrategy.class.isInstance(strategy)) {
            return (MultiTenancyStrategy)((Object)strategy);
        }
        String strategyName = strategy.toString();
        try {
            return MultiTenancyStrategy.valueOf(strategyName.toUpperCase(Locale.ROOT));
        }
        catch (RuntimeException e) {
            LOG.warn("Unknown multi tenancy strategy [ " + strategyName + " ], using MultiTenancyStrategy.NONE.");
            return NONE;
        }
    }

    static {
        LOG = Logger.getMessageLogger(CoreMessageLogger.class, MultiTenancyStrategy.class.getName());
    }
}

