/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.javax.swing.filechooser;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.UIManager;
import org.evosuite.runtime.mock.javax.swing.filechooser.MockFileSystemView;

class MockWindowsFileSystemView
extends MockFileSystemView {
    private static final String newFolderString = UIManager.getString("FileChooser.win32.newFolder");
    private static final String newFolderNextString = UIManager.getString("FileChooser.win32.newFolder.subsequent");

    MockWindowsFileSystemView() {
    }

    @Override
    public Boolean isTraversable(File f) {
        return this.isFileSystemRoot(f) || this.isComputerNode(f) || f.isDirectory();
    }

    @Override
    public File getChild(File parent, String fileName) {
        String path;
        if (fileName.startsWith("\\") && !fileName.startsWith("\\\\") && this.isFileSystem(parent) && (path = parent.getAbsolutePath()).length() >= 2 && path.charAt(1) == ':' && Character.isLetter(path.charAt(0))) {
            return this.createFileObject(path.substring(0, 2) + fileName);
        }
        return super.getChild(parent, fileName);
    }

    @Override
    public String getSystemTypeDescription(File f) {
        return super.getSystemTypeDescription(f);
    }

    @Override
    public File getHomeDirectory() {
        return this.getRoots()[0];
    }

    @Override
    public File createNewFolder(File containingDir) throws IOException {
        if (containingDir == null) {
            throw new IOException("Containing directory is null:");
        }
        File newFolder = this.createFileObject(containingDir, newFolderString);
        for (int i = 2; newFolder.exists() && i < 100; ++i) {
            newFolder = this.createFileObject(containingDir, MessageFormat.format(newFolderNextString, new Integer(i)));
        }
        if (newFolder.exists()) {
            throw new IOException("Directory already exists:" + newFolder.getAbsolutePath());
        }
        newFolder.mkdirs();
        return newFolder;
    }

    @Override
    public boolean isDrive(File dir) {
        return this.isFileSystemRoot(dir);
    }

    @Override
    public boolean isFloppyDrive(File dir) {
        String path = dir.getAbsolutePath();
        return path != null && (path.equals("A:\\") || path.equals("B:\\"));
    }

    @Override
    public File createFileObject(String path) {
        if (path.length() >= 2 && path.charAt(1) == ':' && Character.isLetter(path.charAt(0))) {
            if (path.length() == 2) {
                path = path + "\\";
            } else if (path.charAt(2) != '\\') {
                path = path.substring(0, 2) + "\\" + path.substring(2);
            }
        }
        return super.createFileObject(path);
    }

    @Override
    protected File createFileSystemRoot(File f) {
        return new MockFileSystemView.MockFileSystemRoot(f){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean exists() {
                return true;
            }
        };
    }
}

