/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.java.net.EvoSuiteSocket;
import org.evosuite.runtime.mock.java.net.MockInetAddress;
import org.evosuite.runtime.mock.java.net.MockInetSocketAddress;
import org.evosuite.runtime.mock.java.net.MockSocketImpl;

public class MockSocket
extends Socket
implements OverrideMock {
    private Object closeLock = new Object();
    private boolean created = false;
    private boolean bound = false;
    private boolean connected = false;
    private boolean closed = false;
    private boolean shutIn = false;
    private boolean shutOut = false;
    MockSocketImpl impl;

    public MockSocket() {
        if (!MockFramework.isEnabled()) {
            return;
        }
        this.setImpl();
    }

    public MockSocket(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("Invalid Proxy");
        }
        Proxy p = proxy;
        if (p.type() == Proxy.Type.SOCKS) {
            InetSocketAddress epoint = (InetSocketAddress)p.address();
            if (epoint.getAddress() != null) {
                this.checkAddress(epoint.getAddress(), "Socket");
            }
            this.impl = new EvoSuiteSocket(p);
            this.impl.setSocket(this);
        } else if (p == Proxy.NO_PROXY) {
            this.impl = new EvoSuiteSocket();
            this.impl.setSocket(this);
        } else {
            throw new IllegalArgumentException("Invalid Proxy");
        }
    }

    protected MockSocket(MockSocketImpl impl) throws SocketException {
        super(impl);
        if (!MockFramework.isEnabled()) {
            return;
        }
        this.impl = impl;
        if (impl != null) {
            this.impl.setSocket(this);
        }
    }

    public MockSocket(String host, int port) throws UnknownHostException, IOException {
        this(host != null ? new MockInetSocketAddress(host, port) : new MockInetSocketAddress(MockInetAddress.getByName(null), port), null, true);
    }

    public MockSocket(InetAddress address, int port) throws IOException {
        this(address != null ? new MockInetSocketAddress(address, port) : null, null, true);
    }

    public MockSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        this(host != null ? new MockInetSocketAddress(host, port) : new MockInetSocketAddress(MockInetAddress.getByName(null), port), new MockInetSocketAddress(localAddr, localPort), true);
    }

    public MockSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        this(address != null ? new MockInetSocketAddress(address, port) : null, new MockInetSocketAddress(localAddr, localPort), true);
    }

    public MockSocket(String host, int port, boolean stream) throws IOException {
        this(host != null ? new MockInetSocketAddress(host, port) : new MockInetSocketAddress(MockInetAddress.getByName(null), port), null, stream);
    }

    public MockSocket(InetAddress host, int port, boolean stream) throws IOException {
        this(host != null ? new MockInetSocketAddress(host, port) : null, new MockInetSocketAddress(0), stream);
    }

    private MockSocket(SocketAddress address, SocketAddress localAddr, boolean stream) throws IOException {
        this.setImpl();
        if (address == null) {
            throw new NullPointerException();
        }
        try {
            this.createImpl(stream);
            if (localAddr != null) {
                this.bind(localAddr);
            }
            if (address != null) {
                this.connect(address);
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    protected void createImpl(boolean stream) throws SocketException {
        if (this.impl == null) {
            this.setImpl();
        }
        try {
            this.impl.create(stream);
            this.created = true;
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    protected void setImpl() {
        this.impl = new EvoSuiteSocket();
        this.impl.setSocket(this);
    }

    protected MockSocketImpl getImpl() throws SocketException {
        if (!this.created) {
            this.createImpl(true);
        }
        return this.impl;
    }

    protected void _postAccept() {
        this.connected = true;
        this.created = true;
        this.bound = true;
    }

    protected void setCreated() {
        this.created = true;
    }

    protected void setBound() {
        this.bound = true;
    }

    protected void setConnected() {
        this.connected = true;
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (endpoint == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isConnected()) {
            throw new SocketException("already connected");
        }
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress epoint = (InetSocketAddress)endpoint;
        InetAddress addr = epoint.getAddress();
        this.checkAddress(addr, "connect");
        if (!this.created) {
            this.createImpl(true);
        }
        this.impl.connect(epoint, timeout);
        this.connected = true;
        this.bound = true;
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (bindpoint != null && !(bindpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress epoint = (InetSocketAddress)bindpoint;
        if (epoint != null && epoint.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        if (epoint == null) {
            epoint = new MockInetSocketAddress(0);
        }
        InetAddress addr = epoint.getAddress();
        int port = epoint.getPort();
        this.checkAddress(addr, "bind");
        this.getImpl().bind(addr, port);
        this.bound = true;
    }

    private void checkAddress(InetAddress addr, String op) {
        if (addr == null) {
            return;
        }
        if (!(addr instanceof Inet4Address) && !(addr instanceof Inet6Address)) {
            throw new IllegalArgumentException(op + ": invalid address type");
        }
    }

    @Override
    public InetAddress getInetAddress() {
        if (!this.isConnected()) {
            return null;
        }
        try {
            return this.getImpl().getInetAddress();
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    @Override
    public InetAddress getLocalAddress() {
        if (!MockFramework.isEnabled()) {
            return super.getLocalAddress();
        }
        if (!this.isBound()) {
            return MockInetAddress.anyLocalAddress();
        }
        InetAddress in = null;
        try {
            in = (InetAddress)this.getImpl().getOption(15);
            if (in.isAnyLocalAddress()) {
                in = MockInetAddress.anyLocalAddress();
            }
        }
        catch (SecurityException e) {
            in = MockInetAddress.getLoopbackAddress();
        }
        catch (Exception e) {
            in = MockInetAddress.anyLocalAddress();
        }
        return in;
    }

    @Override
    public int getPort() {
        if (!this.isConnected()) {
            return 0;
        }
        try {
            return this.getImpl().getPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    @Override
    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new MockInetSocketAddress(this.getInetAddress(), this.getPort());
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new MockInetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    @Override
    public SocketChannel getChannel() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        return this.impl.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        return this.impl.getOutputStream();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(1, (Object)on);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(1);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!on) {
            this.getImpl().setOption(128, new Boolean(on));
        } else {
            if (linger < 0) {
                throw new IllegalArgumentException("invalid value for SO_LINGER");
            }
            if (linger > 65535) {
                linger = 65535;
            }
            this.getImpl().setOption(128, new Integer(linger));
        }
    }

    @Override
    public int getSoLinger() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object o = this.getImpl().getOption(128);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return -1;
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        if (!this.getImpl().supportsUrgentData()) {
            throw new SocketException("Urgent data not supported");
        }
        this.getImpl().sendUrgentData(data);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4099, (Object)on);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(4099);
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.getImpl().setOption(4102, new Integer(timeout));
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object o = this.getImpl().getOption(4102);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("negative send size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4097, new Integer(size));
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int result = 0;
        Object o = this.getImpl().getOption(4097);
        if (o instanceof Integer) {
            result = (Integer)o;
        }
        return result;
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("invalid receive size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4098, new Integer(size));
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int result = 0;
        Object o = this.getImpl().getOption(4098);
        if (o instanceof Integer) {
            result = (Integer)o;
        }
        return result;
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(8, (Object)on);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(8);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        if (tc < 0 || tc > 255) {
            throw new IllegalArgumentException("tc is not in range 0 -- 255");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(3, new Integer(tc));
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return (Integer)this.getImpl().getOption(3);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4, (Object)on);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            if (this.created) {
                this.impl.close();
            }
            this.closed = true;
        }
    }

    @Override
    public void shutdownInput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is already shutdown");
        }
        this.getImpl().shutdownInput();
        this.shutIn = true;
    }

    @Override
    public void shutdownOutput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is already shutdown");
        }
        this.getImpl().shutdownOutput();
        this.shutOut = true;
    }

    @Override
    public String toString() {
        try {
            if (this.isConnected()) {
                return "Socket[addr=" + this.getImpl().getInetAddress() + ",port=" + this.getImpl().getPort() + ",localport=" + this.getImpl().getLocalPort() + "]";
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return "Socket[unconnected]";
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isBound() {
        return this.bound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    @Override
    public boolean isInputShutdown() {
        return this.shutIn;
    }

    @Override
    public boolean isOutputShutdown() {
        return this.shutOut;
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory fac) throws IOException {
        throw new IOException("Setting of factory is not supported in virtual network");
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        super.setPerformancePreferences(connectionTime, latency, bandwidth);
    }
}

