/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.runtime.mock.java.net.MockInetAddress;
import org.evosuite.runtime.mock.java.net.MockInetSocketAddress;
import org.evosuite.runtime.mock.java.net.MockSocketImpl;
import org.evosuite.runtime.mock.java.net.SocketIn;
import org.evosuite.runtime.mock.java.net.SocketOut;
import org.evosuite.runtime.vnet.EndPointInfo;
import org.evosuite.runtime.vnet.NativeTcp;
import org.evosuite.runtime.vnet.VirtualNetwork;

public class EvoSuiteSocket
extends MockSocketImpl {
    private final Map<Integer, Object> options = new ConcurrentHashMap<Integer, Object>();
    private NativeTcp openedConnection;
    private volatile boolean isClosed;
    private volatile boolean isBound;
    protected boolean stream;

    public EvoSuiteSocket() {
        this.initOptions();
        this.isClosed = false;
        this.isBound = false;
    }

    public EvoSuiteSocket(Proxy proxy) {
        this();
        SocketAddress a = proxy.address();
        if (a instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)a;
        }
    }

    private void initOptions() {
        this.options.put(4102, 0);
        this.options.put(4098, 131072);
        this.options.put(4097, 131072);
        this.options.put(128, -1);
        this.options.put(8, false);
        this.options.put(4099, false);
        this.options.put(4, false);
        this.options.put(1, false);
        this.options.put(3, 0);
    }

    @Override
    public void setOption(int optID, Object value) throws SocketException {
        this.options.put(optID, value);
    }

    public int getTimeout() {
        return (Integer)this.options.get(4102);
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        return this.options.get(optID);
    }

    @Override
    protected synchronized void create(boolean stream) throws IOException {
        this.stream = stream;
        if (!stream) {
            this.socketCreate(false);
        } else {
            this.socketCreate(true);
        }
        if (this.socket != null) {
            this.socket.setCreated();
        }
        if (this.serverSocket != null) {
            this.serverSocket.setCreated();
        }
    }

    protected void socketCreate(boolean isStream) {
    }

    @Override
    protected void connect(String host, int port) throws UnknownHostException, IOException {
        this.connect(new MockInetSocketAddress(MockInetAddress.getByName(host), port), this.getTimeout());
    }

    @Override
    protected void connect(InetAddress address, int port) throws IOException {
        this.connect(new MockInetSocketAddress(address, port), this.getTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect(SocketAddress remoteAddress, int timeout) throws IOException {
        if (!this.isBound) {
            InetAddress localHost = MockInetAddress.anyLocalAddress();
            this.bind(localHost, 0);
        }
        boolean connected = false;
        try {
            if (remoteAddress == null || !(remoteAddress instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("unsupported address type");
            }
            InetSocketAddress addr = (InetSocketAddress)remoteAddress;
            if (addr.isUnresolved()) {
                throw new UnknownHostException(addr.getHostName());
            }
            this.port = addr.getPort();
            this.address = addr.getAddress();
            this.connectToAddress(this.address, this.port, timeout);
            connected = true;
        }
        finally {
            if (!connected) {
                try {
                    this.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected void bind(InetAddress host, int port) throws IOException {
        boolean opened;
        if (port == 0) {
            port = VirtualNetwork.getInstance().getNewLocalEphemeralPort();
        }
        if (!(opened = VirtualNetwork.getInstance().openTcpServer(host.getHostAddress(), port))) {
            throw new IOException("Failed to open TCP port");
        }
        this.localport = port;
        this.setOption(15, host);
        this.isBound = true;
    }

    @Override
    protected void listen(int backlog) throws IOException {
    }

    @Override
    protected void accept(SocketImpl s) throws IOException {
        if (!(s instanceof EvoSuiteSocket)) {
            throw new IOException("Can only handle mocked sockets");
        }
        EvoSuiteSocket mock = (EvoSuiteSocket)s;
        InetAddress localHost = (InetAddress)this.options.get(15);
        NativeTcp tcp = VirtualNetwork.getInstance().pullTcpConnection(localHost.getHostAddress(), this.localport);
        if (tcp == null) {
            throw new IOException("Simulated exception on waiting server");
        }
        mock.openedConnection = tcp;
        mock.setOption(15, localHost);
        mock.setLocalPort(this.localport);
        mock.setRemoteAddress(InetAddress.getByName(tcp.getRemoteEndPoint().getHost()));
        mock.setRemotePort(tcp.getRemoteEndPoint().getPort());
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        this.checkIfClosed();
        return new SocketIn(this.openedConnection, true);
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        this.checkIfClosed();
        return new SocketOut(this.openedConnection, true);
    }

    @Override
    protected int available() throws IOException {
        this.checkIfClosed();
        if (this.openedConnection == null) {
            return 0;
        }
        return this.openedConnection.getAmountOfDataInLocalBuffer();
    }

    @Override
    protected void close() throws IOException {
        this.isClosed = true;
    }

    @Override
    protected void sendUrgentData(int data) throws IOException {
        this.checkIfClosed();
    }

    protected void connectToAddress(InetAddress address, int port, int timeout) throws IOException {
        if (address.isAnyLocalAddress()) {
            this.doConnect(MockInetAddress.getLocalHost(), port, timeout);
        } else {
            this.doConnect(address, port, timeout);
        }
    }

    protected synchronized void doConnect(InetAddress address, int port, int timeout) throws IOException {
        EndPointInfo remoteTarget = new EndPointInfo(address.getHostAddress(), port, VirtualNetwork.ConnectionType.TCP);
        InetAddress localHost = (InetAddress)this.getOption(15);
        EndPointInfo localOrigin = new EndPointInfo(localHost.getHostAddress(), this.localport, VirtualNetwork.ConnectionType.TCP);
        this.openedConnection = VirtualNetwork.getInstance().connectToRemoteAddress(localOrigin, remoteTarget);
        this.setRemoteAddress(address);
        this.setRemotePort(port);
    }

    protected void checkIfClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection is closed");
        }
    }
}

