/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.io.MockFileOutputStream;
import org.evosuite.runtime.vfs.VirtualFileSystem;

public class MockFileWriter
extends FileWriter
implements OverrideMock {
    private OutputStreamWriter stream;

    public MockFileWriter(String fileName) throws IOException {
        this(fileName != null ? (!MockFramework.isEnabled() ? new File(fileName) : new MockFile(fileName)) : null);
    }

    public MockFileWriter(String fileName, boolean append) throws IOException {
        this(fileName != null ? (!MockFramework.isEnabled() ? new File(fileName) : new MockFile(fileName)) : null, append);
    }

    public MockFileWriter(File file) throws IOException {
        this(file, false);
    }

    public MockFileWriter(File file, boolean append) throws IOException {
        super(!MockFramework.isEnabled() ? file : VirtualFileSystem.getInstance().getRealTmpFile(), append);
        if (!MockFramework.isEnabled()) {
            return;
        }
        MockFileOutputStream mock = new MockFileOutputStream(file, append);
        this.stream = new OutputStreamWriter(mock);
        VirtualFileSystem.getInstance().addLeakingResource(mock);
    }

    public MockFileWriter(FileDescriptor fd) {
        super(fd);
    }

    @Override
    public String getEncoding() {
        if (!MockFramework.isEnabled()) {
            return super.getEncoding();
        }
        return this.stream.getEncoding();
    }

    @Override
    public void write(int c) throws IOException {
        if (!MockFramework.isEnabled()) {
            super.write(c);
            return;
        }
        this.stream.write(c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!MockFramework.isEnabled()) {
            super.write(cbuf, off, len);
            return;
        }
        this.stream.write(cbuf, off, len);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (!MockFramework.isEnabled()) {
            super.write(str, off, len);
            return;
        }
        this.stream.write(str, off, len);
    }

    @Override
    public void flush() throws IOException {
        if (!MockFramework.isEnabled()) {
            super.flush();
            return;
        }
        this.stream.flush();
    }

    @Override
    public void close() throws IOException {
        if (!MockFramework.isEnabled()) {
            super.close();
            return;
        }
        this.stream.close();
    }
}

