/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.jvm;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.evosuite.runtime.sandbox.Sandbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHookHandler {
    private static final Logger logger = LoggerFactory.getLogger(ShutdownHookHandler.class);
    private static ShutdownHookHandler instance = new ShutdownHookHandler();
    private IdentityHashMap<Thread, Thread> hooksReference;
    private IdentityHashMap<Thread, Thread> existingHooks;

    private ShutdownHookHandler() {
        try {
            Field field = Class.forName("java.lang.ApplicationShutdownHooks").getDeclaredField("hooks");
            field.setAccessible(true);
            this.hooksReference = (IdentityHashMap)field.get(null);
        }
        catch (Exception e) {
            String msg = "Failed to initialize shutdown hook handling";
            logger.error(msg);
        }
    }

    public static ShutdownHookHandler getInstance() {
        return instance;
    }

    public void initHandler() {
        List<Thread> list;
        if (this.hooksReference == null) {
            return;
        }
        if (this.existingHooks != null && (list = this.removeNewHooks()) != null && !list.isEmpty()) {
            logger.warn("Previous hooks were not executed. Going to remove them");
        }
        this.existingHooks = new IdentityHashMap();
        this.existingHooks.putAll(this.hooksReference);
    }

    public List<Thread> getAddedHooks() {
        if (this.hooksReference == null || this.existingHooks == null) {
            return null;
        }
        ArrayList<Thread> list = new ArrayList<Thread>();
        for (Thread t : this.hooksReference.values()) {
            if (this.existingHooks.containsKey(t)) continue;
            list.add(t);
        }
        return list;
    }

    public int getNumberOfAllExistingHooks() {
        if (this.hooksReference == null) {
            return -1;
        }
        return this.hooksReference.size();
    }

    public void processWasHalted() {
        this.removeNewHooks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int safeExecuteAddedHooks() {
        boolean safe = Sandbox.isSafeToExecuteSUTCode();
        int n = -1;
        assert (!Sandbox.isSecurityManagerInitialized() || Sandbox.isOnAndExecutingSUTCode()) : "Executing hooks outside of a test case, but with sandbox on";
        try {
            if (!safe) {
                Sandbox.goingToExecuteUnsafeCodeOnSameThread();
            }
            n = this.executeAddedHooks();
        }
        catch (Throwable t) {
            logger.debug("Shutdown hooks threw exception: " + t);
        }
        finally {
            if (!safe) {
                Sandbox.doneWithExecutingUnsafeCodeOnSameThread();
            }
        }
        return n;
    }

    public int executeAddedHooks() {
        List<Thread> list = this.removeNewHooks();
        if (list == null || list.isEmpty()) {
            return 0;
        }
        for (Thread t : list) {
            t.run();
        }
        return list.size();
    }

    private List<Thread> removeNewHooks() {
        List<Thread> list = this.getAddedHooks();
        this.existingHooks = null;
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (Thread t : list) {
            if (t.getName().equals("CloverShutdownFlusher")) continue;
            this.hooksReference.remove(t);
        }
        return list;
    }
}

