/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Vector;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.serial.SerialException;

public class SerialJavaObject
implements Serializable,
Cloneable {
    private Object obj;
    private transient Field[] fields;
    static final long serialVersionUID = -1465795139032831023L;
    Vector chain;

    public SerialJavaObject(Object obj) throws SerialException {
        Class<?> c = obj.getClass();
        boolean serializableImpl = false;
        Class<?>[] theIf = c.getInterfaces();
        for (int i = 0; i < theIf.length; ++i) {
            String ifName = theIf[i].getName();
            if (ifName != "java.io.Serializable") continue;
            serializableImpl = true;
        }
        boolean anyStaticFields = false;
        this.fields = c.getFields();
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].getModifiers() != 8) continue;
            anyStaticFields = true;
        }
        try {
            if (!serializableImpl) {
                throw new RowSetWarning("Test");
            }
        }
        catch (RowSetWarning w) {
            this.setWarning(w);
        }
        if (anyStaticFields) {
            throw new SerialException("Located static fields in object instance. Cannot serialize");
        }
        this.obj = obj;
    }

    public Object getObject() throws SerialException {
        return this.obj;
    }

    public Field[] getFields() throws SerialException {
        if (this.fields != null) {
            Class<?> c = this.obj.getClass();
            return c.getFields();
        }
        throw new SerialException("SerialJavaObject does not contain a serialized object instance");
    }

    private void setWarning(RowSetWarning e) {
        if (this.chain == null) {
            this.chain = new Vector();
        }
        this.chain.add(e);
    }
}

