/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.CachedRowSetImpl;
import com.sun.rowset.JdbcRowSetResourceBundle;
import com.sun.rowset.internal.CachedRowSetReader;
import com.sun.rowset.internal.SyncResolverImpl;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import javax.sql.RowSetInternal;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetMetaDataImpl;
import javax.sql.rowset.spi.SyncProviderException;
import javax.sql.rowset.spi.TransactionalWriter;

public class CachedRowSetWriter
implements TransactionalWriter,
Serializable {
    private transient Connection con;
    private String selectCmd;
    private String updateCmd;
    private String updateWhere;
    private String deleteCmd;
    private String deleteWhere;
    private String insertCmd;
    private int[] keyCols;
    private Object[] params;
    private CachedRowSetReader reader;
    private ResultSetMetaData callerMd;
    private int callerColumnCount;
    private CachedRowSetImpl crsResolve;
    private ArrayList status;
    private int iChangedValsInDbAndCRS;
    private int iChangedValsinDbOnly;
    private JdbcRowSetResourceBundle resBundle;

    public CachedRowSetWriter() {
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public boolean writeData(RowSetInternal caller) throws SQLException {
        boolean conflict = false;
        boolean showDel = false;
        Statement pstmtIns = null;
        this.iChangedValsInDbAndCRS = 0;
        this.iChangedValsinDbOnly = 0;
        CachedRowSetImpl crs = (CachedRowSetImpl)caller;
        this.crsResolve = new CachedRowSetImpl();
        this.con = this.reader.connect(caller);
        if (this.con == null) {
            throw new SQLException(this.resBundle.handleGetObject("crswriter.connect").toString());
        }
        this.initSQLStatements(crs);
        RowSetMetaDataImpl rsmdWrite = (RowSetMetaDataImpl)crs.getMetaData();
        RowSetMetaDataImpl rsmdResolv = new RowSetMetaDataImpl();
        int iColCount = rsmdWrite.getColumnCount();
        int sz = crs.size() + 1;
        this.status = new ArrayList(sz);
        this.status.add(0, null);
        rsmdResolv.setColumnCount(iColCount);
        for (int i = 1; i <= iColCount; ++i) {
            rsmdResolv.setColumnType(i, rsmdWrite.getColumnType(i));
            rsmdResolv.setColumnName(i, rsmdWrite.getColumnName(i));
            rsmdResolv.setNullable(i, 2);
        }
        this.crsResolve.setMetaData(rsmdResolv);
        if (this.callerColumnCount < 1) {
            if (this.reader.getCloseConnection()) {
                this.con.close();
            }
            return true;
        }
        showDel = crs.getShowDeleted();
        crs.setShowDeleted(true);
        crs.beforeFirst();
        int rows = 1;
        while (crs.next()) {
            if (crs.rowDeleted()) {
                conflict = this.deleteOriginalRow(crs, this.crsResolve);
                if (conflict) {
                    this.status.add(rows, new Integer(1));
                } else {
                    this.status.add(rows, new Integer(3));
                }
            } else if (crs.rowInserted()) {
                pstmtIns = this.con.prepareStatement(this.insertCmd);
                conflict = this.insertNewRow(crs, (PreparedStatement)pstmtIns, this.crsResolve);
                if (conflict) {
                    this.status.add(rows, new Integer(2));
                } else {
                    this.status.add(rows, new Integer(3));
                }
            } else if (crs.rowUpdated()) {
                conflict = this.updateOriginalRow(crs);
                if (conflict) {
                    this.status.add(rows, new Integer(0));
                } else {
                    this.status.add(rows, new Integer(3));
                }
            } else {
                int icolCount = crs.getMetaData().getColumnCount();
                this.status.add(rows, new Integer(3));
                this.crsResolve.moveToInsertRow();
                for (int cols = 0; cols < iColCount; ++cols) {
                    this.crsResolve.updateNull(cols + 1);
                }
                this.crsResolve.insertRow();
                this.crsResolve.moveToCurrentRow();
            }
            ++rows;
        }
        if (pstmtIns != null) {
            pstmtIns.close();
        }
        crs.setShowDeleted(showDel);
        boolean boolConf = false;
        for (int j = 1; j < this.status.size(); ++j) {
            if (this.status.get(j).equals(new Integer(3))) continue;
            boolConf = true;
            break;
        }
        crs.beforeFirst();
        this.crsResolve.beforeFirst();
        if (boolConf) {
            SyncProviderException spe = new SyncProviderException(this.status.size() - 1 + this.resBundle.handleGetObject("crswriter.conflictsno").toString());
            SyncResolverImpl syncResImpl = (SyncResolverImpl)spe.getSyncResolver();
            syncResImpl.setCachedRowSet(crs);
            syncResImpl.setCachedRowSetResolver(this.crsResolve);
            syncResImpl.setStatus(this.status);
            syncResImpl.setCachedRowSetWriter(this);
            throw spe;
        }
        return true;
    }

    private boolean updateOriginalRow(CachedRowSet crs) throws SQLException {
        int i = 0;
        int idx = 0;
        ResultSet origVals = crs.getOriginalRow();
        origVals.next();
        try {
            this.updateWhere = this.buildWhereClause(this.updateWhere, origVals);
            String tempselectCmd = this.selectCmd.toLowerCase();
            int idxWhere = tempselectCmd.indexOf("where");
            if (idxWhere != -1) {
                String tempSelect;
                this.selectCmd = tempSelect = this.selectCmd.substring(0, idxWhere);
            }
            PreparedStatement pstmt = this.con.prepareStatement(this.selectCmd + this.updateWhere, 1005, 1007);
            for (i = 0; i < this.keyCols.length; ++i) {
                if (this.params[i] == null) continue;
                pstmt.setObject(++idx, this.params[i]);
            }
            try {
                pstmt.setMaxRows(crs.getMaxRows());
                pstmt.setMaxFieldSize(crs.getMaxFieldSize());
                pstmt.setEscapeProcessing(crs.getEscapeProcessing());
                pstmt.setQueryTimeout(crs.getQueryTimeout());
            }
            catch (Exception ex) {
                // empty catch block
            }
            ResultSet rs = null;
            rs = pstmt.executeQuery();
            if (rs.next()) {
                if (rs.next()) {
                    return true;
                }
                rs.first();
                int colsNotChanged = 0;
                Vector<Integer> cols = new Vector<Integer>();
                String updateExec = new String(this.updateCmd);
                boolean boolNull = true;
                Object objVal = null;
                boolean first = true;
                boolean flag = true;
                this.crsResolve.moveToInsertRow();
                for (i = 1; i <= this.callerColumnCount; ++i) {
                    Object orig = origVals.getObject(i);
                    Object curr = crs.getObject(i);
                    Object rsval = rs.getObject(i);
                    boolNull = true;
                    if (rsval == null && orig != null) {
                        ++this.iChangedValsinDbOnly;
                        boolNull = false;
                        objVal = rsval;
                    } else if (rsval != null && !rsval.equals(orig)) {
                        ++this.iChangedValsinDbOnly;
                        boolNull = false;
                        objVal = rsval;
                    } else if (orig == null || curr == null) {
                        if (!first || !flag) {
                            updateExec = updateExec + ", ";
                        }
                        updateExec = updateExec + crs.getMetaData().getColumnName(i);
                        cols.add(new Integer(i));
                        updateExec = updateExec + " = ? ";
                        first = false;
                    } else if (orig.equals(curr)) {
                        ++colsNotChanged;
                    } else if (!orig.equals(curr) && crs.columnUpdated(i)) {
                        if (rsval.equals(orig)) {
                            if (!flag || !first) {
                                updateExec = updateExec + ", ";
                            }
                            updateExec = updateExec + crs.getMetaData().getColumnName(i);
                            cols.add(new Integer(i));
                            updateExec = updateExec + " = ? ";
                            flag = false;
                        } else {
                            boolNull = false;
                            objVal = rsval;
                            ++this.iChangedValsInDbAndCRS;
                        }
                    }
                    if (!boolNull) {
                        this.crsResolve.updateObject(i, objVal);
                        continue;
                    }
                    this.crsResolve.updateNull(i);
                }
                this.crsResolve.insertRow();
                this.crsResolve.moveToCurrentRow();
                if (!first && cols.size() == 0 || colsNotChanged == this.callerColumnCount) {
                    return false;
                }
                if (this.iChangedValsInDbAndCRS != 0 || this.iChangedValsinDbOnly != 0) {
                    return true;
                }
                updateExec = updateExec + this.updateWhere;
                pstmt = this.con.prepareStatement(updateExec);
                for (i = 0; i < cols.size(); ++i) {
                    Object obj = crs.getObject((Integer)cols.get(i));
                    if (obj != null) {
                        pstmt.setObject(i + 1, obj);
                        continue;
                    }
                    pstmt.setNull(i + 1, crs.getMetaData().getColumnType(i + 1));
                }
                idx = i;
                for (i = 0; i < this.keyCols.length; ++i) {
                    if (this.params[i] == null) continue;
                    pstmt.setObject(++idx, this.params[i]);
                }
                i = pstmt.executeUpdate();
                return false;
            }
            return true;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            this.crsResolve.moveToInsertRow();
            for (i = 1; i <= this.callerColumnCount; ++i) {
                this.crsResolve.updateNull(i);
            }
            this.crsResolve.insertRow();
            this.crsResolve.moveToCurrentRow();
            return true;
        }
    }

    private boolean insertNewRow(CachedRowSet crs, PreparedStatement pstmt, CachedRowSetImpl crsRes) throws SQLException {
        int i = 0;
        int icolCount = crs.getMetaData().getColumnCount();
        boolean returnVal = false;
        PreparedStatement pstmtSel = this.con.prepareStatement(this.selectCmd, 1005, 1007);
        ResultSet rs2 = null;
        DatabaseMetaData dbmd = this.con.getMetaData();
        ResultSet rs = pstmtSel.executeQuery();
        String table = crs.getTableName();
        rs2 = dbmd.getPrimaryKeys(null, null, table);
        String[] primaryKeys = new String[icolCount];
        int k = 0;
        while (rs2.next()) {
            String pkcolname;
            primaryKeys[k] = pkcolname = rs2.getString("COLUMN_NAME");
            ++k;
        }
        if (rs.next()) {
            for (int j = 0; j < primaryKeys.length; ++j) {
                String rsPK;
                if (primaryKeys[j] == null) continue;
                if (crs.getObject(primaryKeys[j]) == null) break;
                String crsPK = crs.getObject(primaryKeys[j]).toString();
                if (!crsPK.equals(rsPK = rs.getObject(primaryKeys[j]).toString())) continue;
                returnVal = true;
                this.crsResolve.moveToInsertRow();
                for (i = 1; i <= icolCount; ++i) {
                    String colname = rs.getMetaData().getColumnName(i);
                    if (colname.equals(primaryKeys[j])) {
                        this.crsResolve.updateObject(i, (Object)rsPK);
                        continue;
                    }
                    this.crsResolve.updateNull(i);
                }
                this.crsResolve.insertRow();
                this.crsResolve.moveToCurrentRow();
            }
        }
        if (returnVal) {
            return returnVal;
        }
        try {
            for (i = 1; i <= icolCount; ++i) {
                Object obj = crs.getObject(i);
                if (obj != null) {
                    pstmt.setObject(i, obj);
                    continue;
                }
                pstmt.setNull(i, crs.getMetaData().getColumnType(i));
            }
            i = pstmt.executeUpdate();
            return false;
        }
        catch (SQLException ex) {
            this.crsResolve.moveToInsertRow();
            for (i = 1; i <= icolCount; ++i) {
                this.crsResolve.updateNull(i);
            }
            this.crsResolve.insertRow();
            this.crsResolve.moveToCurrentRow();
            return true;
        }
    }

    private boolean deleteOriginalRow(CachedRowSet crs, CachedRowSetImpl crsRes) throws SQLException {
        int i;
        int idx = 0;
        ResultSet origVals = crs.getOriginalRow();
        origVals.next();
        this.deleteWhere = this.buildWhereClause(this.deleteWhere, origVals);
        PreparedStatement pstmt = this.con.prepareStatement(this.selectCmd + this.deleteWhere, 1005, 1007);
        for (i = 0; i < this.keyCols.length; ++i) {
            if (this.params[i] == null) continue;
            pstmt.setObject(++idx, this.params[i]);
        }
        try {
            pstmt.setMaxRows(crs.getMaxRows());
            pstmt.setMaxFieldSize(crs.getMaxFieldSize());
            pstmt.setEscapeProcessing(crs.getEscapeProcessing());
            pstmt.setQueryTimeout(crs.getQueryTimeout());
        }
        catch (Exception ex) {
            // empty catch block
        }
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            if (rs.next()) {
                return true;
            }
            rs.first();
            boolean boolChanged = false;
            crsRes.moveToInsertRow();
            for (i = 1; i <= crs.getMetaData().getColumnCount(); ++i) {
                Object original = origVals.getObject(i);
                Object changed = rs.getObject(i);
                if (original != null && changed != null) {
                    if (original.toString().equals(changed.toString())) continue;
                    boolChanged = true;
                    crsRes.updateObject(i, origVals.getObject(i));
                    continue;
                }
                crsRes.updateNull(i);
            }
            crsRes.insertRow();
            crsRes.moveToCurrentRow();
            if (boolChanged) {
                return true;
            }
            String cmd = this.deleteCmd + this.deleteWhere;
            pstmt = this.con.prepareStatement(cmd);
            idx = 0;
            for (i = 0; i < this.keyCols.length; ++i) {
                if (this.params[i] == null) continue;
                pstmt.setObject(++idx, this.params[i]);
            }
            if (pstmt.executeUpdate() != 1) {
                return true;
            }
        } else {
            return true;
        }
        pstmt.close();
        return false;
    }

    public void setReader(CachedRowSetReader reader) throws SQLException {
        this.reader = reader;
    }

    public CachedRowSetReader getReader() throws SQLException {
        return this.reader;
    }

    private void initSQLStatements(CachedRowSet caller) throws SQLException {
        int i;
        this.callerMd = caller.getMetaData();
        this.callerColumnCount = this.callerMd.getColumnCount();
        if (this.callerColumnCount < 1) {
            return;
        }
        String table = caller.getTableName();
        if (table == null && ((table = this.callerMd.getTableName(1)) == null || table.length() == 0)) {
            throw new SQLException(this.resBundle.handleGetObject("crswriter.tname").toString());
        }
        String catalog = this.callerMd.getCatalogName(1);
        String schema = this.callerMd.getSchemaName(1);
        DatabaseMetaData dbmd = this.con.getMetaData();
        this.selectCmd = "SELECT ";
        for (i = 1; i <= this.callerColumnCount; ++i) {
            this.selectCmd = this.selectCmd + this.callerMd.getColumnName(i);
            this.selectCmd = i < this.callerMd.getColumnCount() ? this.selectCmd + ", " : this.selectCmd + " ";
        }
        this.selectCmd = this.selectCmd + "FROM " + this.buildTableName(dbmd, catalog, schema, table);
        this.updateCmd = "UPDATE " + this.buildTableName(dbmd, catalog, schema, table);
        String tempupdCmd = this.updateCmd.toLowerCase();
        int idxupWhere = tempupdCmd.indexOf("where");
        if (idxupWhere != -1) {
            this.updateCmd = this.updateCmd.substring(0, idxupWhere);
        }
        this.updateCmd = this.updateCmd + "SET ";
        this.insertCmd = "INSERT INTO " + this.buildTableName(dbmd, catalog, schema, table);
        this.insertCmd = this.insertCmd + "(";
        for (i = 1; i <= this.callerColumnCount; ++i) {
            this.insertCmd = this.insertCmd + this.callerMd.getColumnName(i);
            this.insertCmd = i < this.callerMd.getColumnCount() ? this.insertCmd + ", " : this.insertCmd + ") VALUES (";
        }
        for (i = 1; i <= this.callerColumnCount; ++i) {
            this.insertCmd = this.insertCmd + "?";
            this.insertCmd = i < this.callerColumnCount ? this.insertCmd + ", " : this.insertCmd + ")";
        }
        this.deleteCmd = "DELETE FROM " + this.buildTableName(dbmd, catalog, schema, table);
        this.buildKeyDesc(caller);
    }

    private String buildTableName(DatabaseMetaData dbmd, String catalog, String schema, String table) throws SQLException {
        String cmd = new String();
        catalog = catalog.trim();
        schema = schema.trim();
        table = table.trim();
        if (dbmd.isCatalogAtStart()) {
            if (catalog != null && catalog.length() > 0) {
                cmd = cmd + catalog + dbmd.getCatalogSeparator();
            }
            if (schema != null && schema.length() > 0) {
                cmd = cmd + schema + ".";
            }
            cmd = cmd + table;
        } else {
            if (schema != null && schema.length() > 0) {
                cmd = cmd + schema + ".";
            }
            cmd = cmd + table;
            if (catalog != null && catalog.length() > 0) {
                cmd = cmd + dbmd.getCatalogSeparator() + catalog;
            }
        }
        cmd = cmd + " ";
        return cmd;
    }

    private void buildKeyDesc(CachedRowSet crs) throws SQLException {
        this.keyCols = crs.getKeyColumns();
        if (this.keyCols == null || this.keyCols.length == 0) {
            this.keyCols = new int[this.callerColumnCount];
            int i = 0;
            while (i < this.keyCols.length) {
                this.keyCols[i++] = i;
            }
        }
        this.params = new Object[this.keyCols.length];
    }

    private String buildWhereClause(String whereClause, ResultSet rs) throws SQLException {
        whereClause = "WHERE ";
        for (int i = 0; i < this.keyCols.length; ++i) {
            if (i > 0) {
                whereClause = whereClause + "AND ";
            }
            whereClause = whereClause + this.callerMd.getColumnName(this.keyCols[i]);
            this.params[i] = rs.getObject(this.keyCols[i]);
            whereClause = rs.wasNull() ? whereClause + " IS NULL " : whereClause + " = ? ";
        }
        return whereClause;
    }

    void updateResolvedConflictToDB(CachedRowSet crs, Connection con) throws SQLException {
        int i;
        int i2;
        String strWhere = "WHERE ";
        String strExec = " ";
        String strUpdate = "UPDATE ";
        int icolCount = crs.getMetaData().getColumnCount();
        int[] keyColumns = crs.getKeyColumns();
        String strSet = "";
        strWhere = this.buildWhereClause(strWhere, crs);
        if (keyColumns == null || keyColumns.length == 0) {
            keyColumns = new int[icolCount];
            int i3 = 0;
            while (i3 < keyColumns.length) {
                keyColumns[i3++] = i3;
            }
        }
        Object[] param = new Object[keyColumns.length];
        strUpdate = "UPDATE " + this.buildTableName(con.getMetaData(), crs.getMetaData().getCatalogName(1), crs.getMetaData().getSchemaName(1), crs.getTableName());
        strUpdate = strUpdate + "SET ";
        boolean first = true;
        for (i2 = 1; i2 <= icolCount; ++i2) {
            if (!crs.columnUpdated(i2)) continue;
            if (!first) {
                strSet = strSet + ", ";
            }
            strSet = strSet + crs.getMetaData().getColumnName(i2);
            strSet = strSet + " = ? ";
            first = false;
        }
        strUpdate = strUpdate + strSet;
        strWhere = "WHERE ";
        for (i2 = 0; i2 < keyColumns.length; ++i2) {
            if (i2 > 0) {
                strWhere = strWhere + "AND ";
            }
            strWhere = strWhere + crs.getMetaData().getColumnName(keyColumns[i2]);
            param[i2] = crs.getObject(keyColumns[i2]);
            strWhere = crs.wasNull() ? strWhere + " IS NULL " : strWhere + " = ? ";
        }
        strUpdate = strUpdate + strWhere;
        PreparedStatement pStmt = con.prepareStatement(strUpdate);
        int idx = 0;
        for (i = 0; i < icolCount; ++i) {
            if (!crs.columnUpdated(i + 1)) continue;
            Object obj = crs.getObject(i + 1);
            if (obj != null) {
                pStmt.setObject(++idx, obj);
                continue;
            }
            pStmt.setNull(i + 1, crs.getMetaData().getColumnType(i + 1));
        }
        for (i = 0; i < keyColumns.length; ++i) {
            if (param[i] == null) continue;
            pStmt.setObject(++idx, param[i]);
        }
        int id = pStmt.executeUpdate();
    }

    public void commit() throws SQLException {
        this.con.commit();
        if (this.reader.getCloseConnection()) {
            this.con.close();
        }
    }

    public void commit(CachedRowSetImpl crs, boolean updateRowset) throws SQLException {
        this.con.commit();
        if (updateRowset && crs.getCommand() != null) {
            crs.execute(this.con);
        }
        if (this.reader.getCloseConnection()) {
            this.con.close();
        }
    }

    public void rollback() throws SQLException {
        this.con.rollback();
        if (this.reader.getCloseConnection()) {
            this.con.close();
        }
    }

    public void rollback(Savepoint s) throws SQLException {
        this.con.rollback(s);
        if (this.reader.getCloseConnection()) {
            this.con.close();
        }
    }
}

